/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProducerAwareProperty;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.util.DeprecationLogger;

public abstract class AbstractProperty<T>
extends AbstractMinimalProvider<T>
implements PropertyInternal<T>,
ProducerAwareProperty {
    private State state = State.Mutable;
    private Task producer;

    @Override
    public void attachProducer(Task task) {
        if (this.producer != null && this.producer != task) {
            throw new IllegalStateException("This property already has a producer task associated with it.");
        }
        this.producer = task;
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        if (this.producer != null) {
            context.add(this.producer);
            return true;
        }
        return false;
    }

    @Override
    public void finalizeValue() {
        if (this.state == State.Mutable || this.state == State.FinalNextGet) {
            this.makeFinal();
        }
        this.state = State.FinalStrict;
    }

    @Override
    public void finalizeValueOnReadAndWarnAboutChanges() {
        if (this.state == State.Mutable) {
            this.state = State.FinalNextGet;
        }
    }

    protected abstract void makeFinal();

    protected void assertReadable() {
        if (this.state == State.FinalNextGet) {
            this.makeFinal();
            this.state = State.FinalLenient;
        }
    }

    protected boolean assertMutable() {
        if (this.state == State.FinalStrict) {
            throw new IllegalStateException("The value for this property is final and cannot be changed any further.");
        }
        if (this.state == State.FinalLenient) {
            DeprecationLogger.nagUserOfDiscontinuedInvocation((String)"Changing the value for a property with a final value");
            return false;
        }
        return true;
    }

    private static enum State {
        Mutable,
        FinalNextGet,
        FinalLenient,
        FinalStrict;

    }
}

