/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotModuleSource;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;

class MavenUniqueSnapshotExternalResourceArtifactResolver
implements ExternalResourceArtifactResolver {
    private final ExternalResourceArtifactResolver delegate;
    private final MavenUniqueSnapshotModuleSource snapshot;

    public MavenUniqueSnapshotExternalResourceArtifactResolver(ExternalResourceArtifactResolver delegate, MavenUniqueSnapshotModuleSource snapshot) {
        this.delegate = delegate;
        this.snapshot = snapshot;
    }

    @Override
    public ModuleSource getSource() {
        return this.snapshot;
    }

    @Override
    public boolean artifactExists(ModuleComponentArtifactMetadata artifact, ResourceAwareResolveResult result) {
        return this.delegate.artifactExists(this.timestamp(artifact), result);
    }

    @Override
    public LocallyAvailableExternalResource resolveArtifact(ModuleComponentArtifactMetadata artifact, ResourceAwareResolveResult result) {
        return this.delegate.resolveArtifact(this.timestamp(artifact), result);
    }

    protected ModuleComponentArtifactMetadata timestamp(ModuleComponentArtifactMetadata artifact) {
        MavenUniqueSnapshotComponentIdentifier snapshotComponentIdentifier = new MavenUniqueSnapshotComponentIdentifier(artifact.getId().getComponentIdentifier(), this.snapshot.getTimestamp());
        return new DefaultModuleComponentArtifactMetadata(snapshotComponentIdentifier, artifact.getName());
    }
}

