/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.OrderInsensitiveTaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.OrderSensitiveTaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TaskFilePropertyCompareStrategy {
    ORDERED(new OrderSensitiveTaskFilePropertyCompareStrategy()),
    UNORDERED(new OrderInsensitiveTaskFilePropertyCompareStrategy());

    private final Impl delegate;

    private TaskFilePropertyCompareStrategy(Impl delegate) {
        this.delegate = delegate;
    }

    public boolean accept(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String propertyTitle, boolean pathIsAbsolute, boolean includeAdded) {
        Iterator<TaskStateChange> trivialResult = TaskFilePropertyCompareStrategy.compareTrivialSnapshots(current, previous, propertyTitle, includeAdded);
        if (trivialResult != null) {
            while (trivialResult.hasNext()) {
                if (visitor.visitChange(trivialResult.next())) continue;
                return false;
            }
            return true;
        }
        return this.delegate.accept(visitor, current, previous, propertyTitle, pathIsAbsolute, includeAdded);
    }

    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        this.delegate.appendToHasher(hasher, snapshots);
    }

    @VisibleForTesting
    static Iterator<TaskStateChange> compareTrivialSnapshots(Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String fileType, boolean includeAdded) {
        switch (current.size()) {
            case 0: {
                switch (previous.size()) {
                    case 0: {
                        return Iterators.emptyIterator();
                    }
                    case 1: {
                        Map.Entry<String, NormalizedFileSnapshot> entry = previous.entrySet().iterator().next();
                        FileChange change = FileChange.removed(entry.getKey(), fileType, entry.getValue().getSnapshot().getType());
                        return Iterators.singletonIterator((Object)change);
                    }
                }
                return null;
            }
            case 1: {
                switch (previous.size()) {
                    case 0: {
                        if (includeAdded) {
                            Map.Entry<String, NormalizedFileSnapshot> entry = current.entrySet().iterator().next();
                            FileChange change = FileChange.added(entry.getKey(), fileType, entry.getValue().getSnapshot().getType());
                            return Iterators.singletonIterator((Object)change);
                        }
                        return Iterators.emptyIterator();
                    }
                    case 1: {
                        Map.Entry<String, NormalizedFileSnapshot> previousEntry = previous.entrySet().iterator().next();
                        Map.Entry<String, NormalizedFileSnapshot> currentEntry = current.entrySet().iterator().next();
                        return TaskFilePropertyCompareStrategy.compareTrivialSnapshotEntries(currentEntry, previousEntry, fileType, includeAdded);
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static Iterator<TaskStateChange> compareTrivialSnapshotEntries(Map.Entry<String, NormalizedFileSnapshot> currentEntry, Map.Entry<String, NormalizedFileSnapshot> previousEntry, String fileType, boolean includeAdded) {
        NormalizedFileSnapshot normalizedPrevious = previousEntry.getValue();
        NormalizedFileSnapshot normalizedCurrent = currentEntry.getValue();
        if (normalizedCurrent.getNormalizedPath().equals(normalizedPrevious.getNormalizedPath())) {
            FileContentSnapshot previousSnapshot = normalizedPrevious.getSnapshot();
            FileContentSnapshot currentSnapshot = normalizedCurrent.getSnapshot();
            if (!currentSnapshot.isContentUpToDate(previousSnapshot)) {
                String path = currentEntry.getKey();
                FileChange change = FileChange.modified(path, fileType, previousSnapshot.getType(), currentSnapshot.getType());
                return Iterators.singletonIterator((Object)change);
            }
            return Iterators.emptyIterator();
        }
        if (includeAdded) {
            String previousPath = previousEntry.getKey();
            String currentPath = currentEntry.getKey();
            FileChange remove = FileChange.removed(previousPath, fileType, normalizedPrevious.getSnapshot().getType());
            FileChange add = FileChange.added(currentPath, fileType, normalizedCurrent.getSnapshot().getType());
            return Iterators.forArray((Object[])new TaskStateChange[]{remove, add});
        }
        String path = previousEntry.getKey();
        FileChange change = FileChange.removed(path, fileType, previousEntry.getValue().getSnapshot().getType());
        return Iterators.singletonIterator((Object)change);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Impl {
        public boolean accept(TaskStateChangeVisitor var1, Map<String, NormalizedFileSnapshot> var2, Map<String, NormalizedFileSnapshot> var3, String var4, boolean var5, boolean var6);

        public void appendToHasher(BuildCacheHasher var1, Collection<NormalizedFileSnapshot> var2);
    }
}

