/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.EmptyFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotBuilder;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.PathNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;

public class CollectingFileCollectionSnapshotBuilder
implements FileCollectionSnapshotBuilder {
    private final Map<String, NormalizedFileSnapshot> snapshots = Maps.newLinkedHashMap();
    private final PathNormalizationStrategy pathNormalizationStrategy;
    private final StringInterner stringInterner;
    private final TaskFilePropertyCompareStrategy compareStrategy;

    public CollectingFileCollectionSnapshotBuilder(TaskFilePropertyCompareStrategy compareStrategy, PathNormalizationStrategy pathNormalizationStrategy, StringInterner stringInterner) {
        this.pathNormalizationStrategy = pathNormalizationStrategy;
        this.stringInterner = stringInterner;
        this.compareStrategy = compareStrategy;
    }

    public void collectFileSnapshot(FileSnapshot fileSnapshot) {
        String absolutePath = fileSnapshot.getPath();
        if (!this.snapshots.containsKey(absolutePath)) {
            NormalizedFileSnapshot normalizedSnapshot = this.pathNormalizationStrategy.getNormalizedSnapshot(fileSnapshot, this.stringInterner);
            this.collectNormalizedFileSnapshot(absolutePath, normalizedSnapshot);
        }
    }

    public void collectNormalizedFileSnapshot(String absolutePath, NormalizedFileSnapshot normalizedSnapshot) {
        if (normalizedSnapshot != null && !this.snapshots.containsKey(absolutePath)) {
            this.snapshots.put(absolutePath, normalizedSnapshot);
        }
    }

    public FileCollectionSnapshot build() {
        if (this.snapshots.isEmpty()) {
            return EmptyFileCollectionSnapshot.INSTANCE;
        }
        return new DefaultFileCollectionSnapshot(this.snapshots, this.compareStrategy, this.pathNormalizationStrategy.isPathAbsolute());
    }
}

