/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitDetector;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassProcessor;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.junit.JUnitOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public class JUnitTestFramework
implements TestFramework {
    private JUnitOptions options;
    private final JUnitDetector detector;
    private final DefaultTestFilter filter;

    public JUnitTestFramework(Test testTask, DefaultTestFilter filter) {
        this.filter = filter;
        this.options = new JUnitOptions();
        this.detector = new JUnitDetector(new ClassFileExtractionManager((Factory<File>)testTask.getTemporaryDirFactory()));
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        return new TestClassProcessorFactoryImpl(new JUnitSpec(this.options.getIncludeCategories(), this.options.getExcludeCategories(), this.filter.getIncludePatterns(), this.filter.getCommandLineIncludePatterns()));
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return new Action<WorkerProcessBuilder>(){

            public void execute(WorkerProcessBuilder workerProcessBuilder) {
                workerProcessBuilder.sharedPackages(new String[]{"junit.framework"});
                workerProcessBuilder.sharedPackages(new String[]{"junit.extensions"});
                workerProcessBuilder.sharedPackages(new String[]{"org.junit"});
            }
        };
    }

    @Override
    public JUnitOptions getOptions() {
        return this.options;
    }

    void setOptions(JUnitOptions options) {
        this.options = options;
    }

    @Override
    public JUnitDetector getDetector() {
        return this.detector;
    }

    private static class TestClassProcessorFactoryImpl
    implements WorkerTestClassProcessorFactory,
    Serializable {
        private final JUnitSpec spec;

        public TestClassProcessorFactoryImpl(JUnitSpec spec) {
            this.spec = spec;
        }

        public TestClassProcessor create(ServiceRegistry serviceRegistry) {
            return new JUnitTestClassProcessor(this.spec, (IdGenerator)serviceRegistry.get(IdGenerator.class), (ActorFactory)serviceRegistry.get(ActorFactory.class), (Clock)serviceRegistry.get(Clock.class));
        }
    }
}

