/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.asm;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.asm.ClassRelevancyFilter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class ClassDependenciesVisitor
extends ClassVisitor {
    private static final int API = 393216;
    private final MethodVisitor methodVisitor;
    private final FieldVisitor fieldVisitor;
    private final IntSet constants;
    private final Set<String> superTypes;
    private final Set<String> types;
    private final Predicate<String> typeFilter;
    private boolean isAnnotationType;
    private boolean dependencyToAll;
    private final RetentionPolicyVisitor retentionPolicyVisitor;
    private final AnnotationVisitor annotationVisitor;

    private ClassDependenciesVisitor(IntSet constantsCollector) {
        this(constantsCollector, null, null, null);
    }

    private ClassDependenciesVisitor(IntSet constantsCollector, Set<String> types, Predicate<String> typeFilter, ClassReader reader) {
        super(393216);
        this.constants = constantsCollector;
        this.types = types;
        this.superTypes = types == null ? null : Sets.newHashSet();
        this.methodVisitor = types == null ? null : new MethodVisitor();
        this.fieldVisitor = types == null ? null : new FieldVisitor();
        this.retentionPolicyVisitor = types == null ? null : new RetentionPolicyVisitor();
        this.annotationVisitor = types == null ? null : new AnnotationVisitor();
        this.typeFilter = typeFilter;
        if (reader != null) {
            this.collectClassDependencies(reader);
        }
    }

    public static ClassAnalysis analyze(String className, ClassReader reader) {
        IntOpenHashSet constants = new IntOpenHashSet(2);
        HashSet classDependencies = Sets.newHashSet();
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor((IntSet)constants, classDependencies, new ClassRelevancyFilter(className), reader);
        reader.accept((ClassVisitor)visitor, 6);
        return new ClassAnalysis(className, classDependencies, visitor.isDependencyToAll(), (IntSet)constants, visitor.getSuperTypes());
    }

    public static IntSet retrieveConstants(ClassReader reader) {
        IntOpenHashSet constants = new IntOpenHashSet(2);
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor((IntSet)constants);
        reader.accept((ClassVisitor)visitor, 6);
        return constants;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAnnotationType = this.isAnnotationType(interfaces);
        if (superName != null) {
            String type = this.typeOfFromSlashyString(superName);
            this.maybeAddSuperType(type);
            this.maybeAddDependentType(type);
        }
        for (String s : interfaces) {
            String interfaceType = this.typeOfFromSlashyString(s);
            this.maybeAddDependentType(interfaceType);
            this.maybeAddSuperType(interfaceType);
        }
    }

    private void collectClassDependencies(ClassReader reader) {
        char[] charBuffer = new char[reader.getMaxStringLength()];
        for (int i = 1; i < reader.getItemCount(); ++i) {
            int itemOffset = reader.getItem(i);
            if (itemOffset <= 0 || reader.readByte(itemOffset - 1) != 7) continue;
            String classDescriptor = reader.readUTF8(itemOffset, charBuffer);
            Type type = Type.getObjectType((String)classDescriptor);
            while (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() != 10) continue;
            String name = type.getClassName();
            this.maybeAddDependentType(name);
        }
    }

    protected void maybeAddSuperType(String type) {
        if (this.superTypes != null && this.typeFilter.apply((Object)type)) {
            this.superTypes.add(type);
        }
    }

    protected void maybeAddDependentType(String type) {
        if (this.types != null && this.typeFilter.apply((Object)type)) {
            this.types.add(type);
        }
    }

    protected String typeOfFromSlashyString(String slashyStyleDesc) {
        return Type.getObjectType((String)slashyStyleDesc).getClassName();
    }

    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    private boolean isAnnotationType(String[] interfaces) {
        return interfaces.length == 1 && interfaces[0].equals("java/lang/annotation/Annotation");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.maybeAddDependentType(this.descTypeOf(desc));
        if (ClassDependenciesVisitor.isAccessibleConstant(access, value) && this.constants != null) {
            this.constants.add((name + '|' + value).hashCode());
        }
        return this.fieldVisitor;
    }

    private static boolean isAccessibleConstant(int access, Object value) {
        return ClassDependenciesVisitor.isConstant(access) && !ClassDependenciesVisitor.isPrivate(access) && value != null;
    }

    protected String descTypeOf(String desc) {
        Type type = Type.getType((String)desc);
        if (type.getSort() == 9 && type.getDimensions() > 0) {
            type = type.getElementType();
        }
        return type.getClassName();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Type methodType = Type.getMethodType((String)desc);
        this.maybeAddDependentType(methodType.getReturnType().getClassName());
        for (Type argType : methodType.getArgumentTypes()) {
            this.maybeAddDependentType(argType.getClassName());
        }
        return this.methodVisitor;
    }

    public org.objectweb.asm.AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isAnnotationType && "Ljava/lang/annotation/Retention;".equals(desc)) {
            return this.retentionPolicyVisitor;
        }
        this.maybeAddDependentType(Type.getType((String)desc).getClassName());
        return this.annotationVisitor;
    }

    private static boolean isPrivate(int access) {
        return (access & 2) != 0;
    }

    private static boolean isConstant(int access) {
        return (access & 0x10) != 0 && (access & 8) != 0;
    }

    public boolean isDependencyToAll() {
        return this.dependencyToAll;
    }

    private class AnnotationVisitor
    extends org.objectweb.asm.AnnotationVisitor {
        public AnnotationVisitor() {
            super(393216);
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                ClassDependenciesVisitor.this.maybeAddDependentType(((Type)value).getClassName());
            }
        }

        public org.objectweb.asm.AnnotationVisitor visitArray(String name) {
            return this;
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String name, String descriptor) {
            ClassDependenciesVisitor.this.maybeAddDependentType(Type.getType((String)descriptor).getClassName());
            return this;
        }
    }

    private class RetentionPolicyVisitor
    extends org.objectweb.asm.AnnotationVisitor {
        public RetentionPolicyVisitor() {
            super(393216);
        }

        public void visitEnum(String name, String desc, String value) {
            RetentionPolicy policy;
            if ("Ljava/lang/annotation/RetentionPolicy;".equals(desc) && (policy = RetentionPolicy.valueOf(value)) == RetentionPolicy.SOURCE) {
                ClassDependenciesVisitor.this.dependencyToAll = true;
            }
        }
    }

    private class MethodVisitor
    extends org.objectweb.asm.MethodVisitor {
        protected MethodVisitor() {
            super(393216);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.descTypeOf(desc));
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(Type.getType((String)descriptor).getClassName());
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public org.objectweb.asm.AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(Type.getType((String)descriptor).getClassName());
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public org.objectweb.asm.AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(Type.getType((String)descriptor).getClassName());
            return ClassDependenciesVisitor.this.annotationVisitor;
        }
    }

    private class FieldVisitor
    extends org.objectweb.asm.FieldVisitor {
        public FieldVisitor() {
            super(393216);
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(Type.getType((String)descriptor).getClassName());
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public org.objectweb.asm.AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(Type.getType((String)descriptor).getClassName());
            return ClassDependenciesVisitor.this.annotationVisitor;
        }
    }
}

