/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.gradle.workers.internal.WorkerDaemonServer;
import org.gradle.workers.internal.WorkerFactory;

@ThreadSafe
public class WorkerDaemonFactory
implements WorkerFactory {
    private final WorkerDaemonClientsManager clientsManager;
    private final BuildOperationExecutor buildOperationExecutor;

    public WorkerDaemonFactory(WorkerDaemonClientsManager clientsManager, BuildOperationExecutor buildOperationExecutor) {
        this.clientsManager = clientsManager;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public Worker getWorker(final DaemonForkOptions forkOptions) {
        return new Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
                WorkerDaemonClient client = WorkerDaemonFactory.this.clientsManager.reserveIdleClient(forkOptions);
                if (client == null) {
                    client = WorkerDaemonFactory.this.clientsManager.reserveNewClient(WorkerDaemonServer.class, forkOptions);
                }
                try {
                    DefaultWorkResult defaultWorkResult = this.executeInClient(client, spec, parentBuildOperation);
                    return defaultWorkResult;
                }
                finally {
                    WorkerDaemonFactory.this.clientsManager.release(client);
                }
            }

            public DefaultWorkResult execute(ActionExecutionSpec spec) {
                return this.execute(spec, WorkerDaemonFactory.this.buildOperationExecutor.getCurrentOperation());
            }

            private DefaultWorkResult executeInClient(final WorkerDaemonClient client, final ActionExecutionSpec spec, final BuildOperationRef parentBuildOperation) {
                return (DefaultWorkResult)WorkerDaemonFactory.this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<DefaultWorkResult>(){

                    public DefaultWorkResult call(BuildOperationContext context) {
                        return client.execute(spec);
                    }

                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName((String)spec.getDisplayName()).parent(parentBuildOperation);
                    }
                });
            }
        };
    }

    public IsolationMode getIsolationMode() {
        return IsolationMode.PROCESS;
    }
}

