/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.AttributeDesugaring;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;

class SelectorState
implements DependencyGraphSelector,
ResolvableSelectorState {
    private final Long id;
    private final DependencyState dependencyState;
    private final DependencyMetadata dependencyMetadata;
    private final DependencyToComponentIdResolver resolver;
    private final ResolvedVersionConstraint versionConstraint;
    private final VersionSelectorScheme versionSelectorScheme;
    private final ImmutableAttributesFactory attributesFactory;
    private ComponentIdResolveResult idResolveResult;
    private ModuleVersionResolveException failure;
    private ModuleResolveState targetModule;
    private boolean resolved;
    private boolean forced;

    SelectorState(Long id, DependencyState dependencyState, DependencyToComponentIdResolver resolver, VersionSelectorScheme versionSelectorScheme, ResolveState resolveState, ModuleIdentifier targetModuleId) {
        this.id = id;
        this.dependencyState = dependencyState;
        this.dependencyMetadata = dependencyState.getDependency();
        this.resolver = resolver;
        this.versionSelectorScheme = versionSelectorScheme;
        this.targetModule = resolveState.getModule(targetModuleId);
        this.versionConstraint = this.resolveVersionConstraint(this.dependencyMetadata.getSelector());
        this.attributesFactory = resolveState.getAttributesFactory();
        this.forced = SelectorState.isForced(this.dependencyMetadata);
        this.targetModule.addSelector(this);
    }

    private ResolvedVersionConstraint resolveVersionConstraint(ComponentSelector selector) {
        if (selector instanceof ModuleComponentSelector) {
            return new DefaultResolvedVersionConstraint(((ModuleComponentSelector)selector).getVersionConstraint(), this.versionSelectorScheme);
        }
        return null;
    }

    @Override
    public Long getResultId() {
        return this.id;
    }

    public String toString() {
        return this.dependencyMetadata.toString();
    }

    @Override
    public ComponentSelector getRequested() {
        return this.selectorWithDesugaredAttributes(this.dependencyState.getRequested());
    }

    public ModuleResolveState getTargetModule() {
        return this.targetModule;
    }

    ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    @Override
    public ComponentIdResolveResult resolve(VersionSelector allRejects) {
        if (!this.requiresResolve(allRejects)) {
            return this.idResolveResult;
        }
        DefaultBuildableComponentIdResolveResult idResolveResult = new DefaultBuildableComponentIdResolveResult();
        if (this.dependencyState.failure != null) {
            idResolveResult.failed(this.dependencyState.failure);
        } else {
            DefaultResolvedVersionConstraint mergedConstraint = this.versionConstraint == null ? null : new DefaultResolvedVersionConstraint(this.versionConstraint.getPreferredSelector(), allRejects);
            this.resolver.resolve(this.dependencyMetadata, mergedConstraint, idResolveResult);
        }
        if (idResolveResult.getFailure() != null) {
            this.failure = idResolveResult.getFailure();
        }
        this.idResolveResult = idResolveResult;
        this.resolved = true;
        return idResolveResult;
    }

    private boolean requiresResolve(VersionSelector allRejects) {
        if (this.idResolveResult == null) {
            return true;
        }
        if (this.idResolveResult.getFailure() != null) {
            return false;
        }
        if (this.idResolveResult.isRejected()) {
            return false;
        }
        return allRejects != null && allRejects.accept(this.idResolveResult.getModuleVersionId().getVersion());
    }

    @Override
    public void markResolved() {
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void overrideSelection(ComponentState selected) {
        this.resolved = true;
        this.targetModule = selected.getModule();
    }

    public ComponentSelectionReasonInternal getSelectionReason() {
        return this.addReasonsForSelector(VersionSelectionReasons.empty());
    }

    ComponentSelectionReasonInternal addReasonsForSelector(ComponentSelectionReasonInternal selectionReason) {
        ComponentSelectionDescriptorInternal dependencyDescriptor;
        ComponentSelectionDescriptorInternal componentSelectionDescriptorInternal = dependencyDescriptor = this.dependencyMetadata.isPending() ? VersionSelectionReasons.CONSTRAINT : VersionSelectionReasons.REQUESTED;
        if (this.dependencyMetadata.getReason() != null) {
            dependencyDescriptor = dependencyDescriptor.withReason(this.dependencyMetadata.getReason());
        }
        selectionReason.addCause(dependencyDescriptor);
        if (this.dependencyState.getRuleDescriptor() != null) {
            selectionReason.addCause(this.dependencyState.getRuleDescriptor());
        }
        return selectionReason;
    }

    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    @Override
    public ResolvedVersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public boolean isForce() {
        return this.forced;
    }

    private ComponentSelector selectorWithDesugaredAttributes(ComponentSelector selector) {
        return AttributeDesugaring.desugarSelector(selector, this.attributesFactory);
    }

    private static boolean isForced(DependencyMetadata dependencyMetadata) {
        return dependencyMetadata instanceof LocalOriginDependencyMetadata && ((LocalOriginDependencyMetadata)dependencyMetadata).isForce();
    }

    public void update(DependencyState dependencyState) {
        if (dependencyState != this.dependencyState) {
            this.forced |= SelectorState.isForced(dependencyState.getDependency());
        }
    }
}

