/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.git.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.StartParameter;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.internal.UncheckedException;
import org.gradle.vcs.git.GitVersionControlSpec;
import org.gradle.vcs.internal.spec.AbstractVersionControlSpec;

public class DefaultGitVersionControlSpec
extends AbstractVersionControlSpec
implements GitVersionControlSpec {
    private URI url;

    public DefaultGitVersionControlSpec(StartParameter rootBuildStartParameter, ClassLoaderScope classLoaderScope) {
        super(rootBuildStartParameter, classLoaderScope);
    }

    @Override
    public URI getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URI url) {
        this.url = url;
    }

    @Override
    public void setUrl(String url) {
        try {
            this.setUrl(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public String getDisplayName() {
        return "Git Repository at " + this.getUrl();
    }

    public String getUniqueId() {
        return "git-repo:" + this.getUrl().toASCIIString();
    }

    public String getRepoName() {
        String[] pathParts = this.url.getPath().split("/");
        String repoPart = pathParts[pathParts.length - 1];
        if (repoPart.endsWith(".git")) {
            repoPart = repoPart.substring(0, repoPart.indexOf(".git"));
        }
        return repoPart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGitVersionControlSpec that = (DefaultGitVersionControlSpec)o;
        return this.url != null ? this.url.equals(that.url) : that.url == null;
    }

    public int hashCode() {
        return this.url != null ? this.url.hashCode() : 0;
    }

    public String toString() {
        return "GitVersionControlSpec{url=" + this.url + '}';
    }
}

