/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultGenericFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.DirectoryFileSnapshot;
import org.gradle.api.internal.changedetection.state.DirectoryTreeDetails;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.FileTreeSnapshot;
import org.gradle.api.internal.changedetection.state.InputPathNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.Snapshot;
import org.gradle.api.internal.changedetection.state.SnapshotFileTreeElement;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.normalization.internal.InputNormalizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileSystemSnapshotter
implements FileSystemSnapshotter {
    private final FileHasher hasher;
    private final StringInterner stringInterner;
    private final FileSystem fileSystem;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileSystemMirror fileSystemMirror;
    private final ProducerGuard<String> producingSelfSnapshots = ProducerGuard.striped();
    private final ProducerGuard<String> producingTrees = ProducerGuard.striped();
    private final ProducerGuard<String> producingAllSnapshots = ProducerGuard.striped();
    private final DefaultGenericFileCollectionSnapshotter snapshotter;

    public DefaultFileSystemSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, DirectoryFileTreeFactory directoryFileTreeFactory, FileSystemMirror fileSystemMirror) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.fileSystem = fileSystem;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileSystemMirror = fileSystemMirror;
        this.snapshotter = new DefaultGenericFileCollectionSnapshotter(stringInterner, directoryFileTreeFactory, this);
    }

    @Override
    public boolean exists(File file) {
        FileSnapshot snapshot = this.fileSystemMirror.getFile(file.getAbsolutePath());
        if (snapshot != null) {
            return snapshot.getType() != FileType.Missing;
        }
        return file.exists();
    }

    @Override
    public FileSnapshot snapshotSelf(final File file) {
        final String path = file.getAbsolutePath();
        return (FileSnapshot)this.producingSelfSnapshots.guardByKey((Object)path, (Factory)new Factory<FileSnapshot>(){

            public FileSnapshot create() {
                FileSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getFile(path);
                if (snapshot == null) {
                    snapshot = DefaultFileSystemSnapshotter.this.calculateDetails(file);
                    DefaultFileSystemSnapshotter.this.fileSystemMirror.putFile(snapshot);
                }
                return snapshot;
            }
        });
    }

    @Override
    public Snapshot snapshotAll(final File file) {
        final String path = file.getAbsolutePath();
        return (Snapshot)this.producingAllSnapshots.guardByKey((Object)path, (Factory)new Factory<Snapshot>(){

            public Snapshot create() {
                Snapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getContent(path);
                if (snapshot == null) {
                    FileCollectionSnapshot fileCollectionSnapshot = DefaultFileSystemSnapshotter.this.snapshotter.snapshot(ImmutableFileCollection.of(file), InputPathNormalizationStrategy.ABSOLUTE, InputNormalizationStrategy.NOT_CONFIGURED);
                    DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
                    fileCollectionSnapshot.appendToHasher((BuildCacheHasher)hasher);
                    HashCode hashCode = hasher.hash();
                    snapshot = new HashBackedSnapshot(hashCode);
                    String internedPath = DefaultFileSystemSnapshotter.this.internPath(file);
                    DefaultFileSystemSnapshotter.this.fileSystemMirror.putContent(internedPath, snapshot);
                }
                return snapshot;
            }
        });
    }

    @Override
    public FileTreeSnapshot snapshotDirectoryTree(final File dir) {
        final String path = dir.getAbsolutePath();
        FileTreeSnapshot snapshot = this.fileSystemMirror.getDirectoryTree(path);
        if (snapshot != null) {
            return snapshot;
        }
        return (FileTreeSnapshot)this.producingTrees.guardByKey((Object)path, (Factory)new Factory<FileTreeSnapshot>(){

            public FileTreeSnapshot create() {
                FileTreeSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getDirectoryTree(path);
                if (snapshot == null) {
                    return DefaultFileSystemSnapshotter.this.snapshotAndCache(DefaultFileSystemSnapshotter.this.directoryFileTreeFactory.create(dir));
                }
                return snapshot;
            }
        });
    }

    @Override
    public FileTreeSnapshot snapshotDirectoryTree(final DirectoryFileTree dirTree) {
        final String path = dirTree.getDir().getAbsolutePath();
        PatternSet patterns = dirTree.getPatterns();
        FileTreeSnapshot snapshot = this.fileSystemMirror.getDirectoryTree(path);
        if (snapshot != null) {
            return this.filterSnapshot(snapshot, patterns);
        }
        if (!patterns.isEmpty()) {
            return this.snapshotWithoutCaching(dirTree);
        }
        return (FileTreeSnapshot)this.producingTrees.guardByKey((Object)path, (Factory)new Factory<FileTreeSnapshot>(){

            public FileTreeSnapshot create() {
                FileTreeSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getDirectoryTree(path);
                if (snapshot == null) {
                    return DefaultFileSystemSnapshotter.this.snapshotAndCache(dirTree);
                }
                return snapshot;
            }
        });
    }

    @Override
    public List<FileSnapshot> snapshotTree(FileTreeInternal tree) {
        ArrayList elements = Lists.newArrayList();
        tree.visitTreeOrBackingFile(new FileVisitorImpl(elements));
        return elements;
    }

    private FileTreeSnapshot snapshotAndCache(DirectoryFileTree directoryTree) {
        String path = this.internPath(directoryTree.getDir());
        ArrayList elements = Lists.newArrayList();
        directoryTree.visit(new FileVisitorImpl(elements));
        ImmutableList descendants = ImmutableList.copyOf((Collection)elements);
        DirectoryTreeDetails snapshot = new DirectoryTreeDetails(path, (Collection<FileSnapshot>)descendants);
        this.fileSystemMirror.putDirectory(snapshot);
        return snapshot;
    }

    private FileTreeSnapshot snapshotWithoutCaching(DirectoryFileTree directoryTree) {
        String path = directoryTree.getDir().getAbsolutePath();
        ArrayList elements = Lists.newArrayList();
        directoryTree.visit(new FileVisitorImpl(elements));
        return new DirectoryTreeDetails(path, elements);
    }

    private FileTreeSnapshot filterSnapshot(FileTreeSnapshot snapshot, PatternSet patterns) {
        if (patterns.isEmpty()) {
            return snapshot;
        }
        final Spec spec = patterns.getAsSpec();
        Collection filteredDescendants = Collections2.filter(snapshot.getDescendants(), (Predicate)new Predicate<FileSnapshot>(){

            public boolean apply(FileSnapshot descendant) {
                return spec.isSatisfiedBy((Object)new SnapshotFileTreeElement(descendant, DefaultFileSystemSnapshotter.this.fileSystem));
            }
        });
        return new DirectoryTreeDetails(snapshot.getPath(), filteredDescendants);
    }

    private String internPath(File file) {
        return this.stringInterner.intern(file.getAbsolutePath());
    }

    private FileSnapshot calculateDetails(File file) {
        String path = this.internPath(file);
        FileMetadataSnapshot stat = this.fileSystem.stat(file);
        switch (stat.getType()) {
            case Missing: {
                return new MissingFileSnapshot(path, new RelativePath(true, new String[]{file.getName()}));
            }
            case Directory: {
                return new DirectoryFileSnapshot(path, new RelativePath(false, new String[]{file.getName()}), true);
            }
            case RegularFile: {
                return new RegularFileSnapshot(path, new RelativePath(true, new String[]{file.getName()}), true, this.fileSnapshot(file, stat));
            }
        }
        throw new IllegalArgumentException("Unrecognized file type: " + stat.getType());
    }

    private FileHashSnapshot fileSnapshot(FileTreeElement fileDetails) {
        return new FileHashSnapshot(this.hasher.hash(fileDetails), fileDetails.getLastModified());
    }

    private FileHashSnapshot fileSnapshot(File file, FileMetadataSnapshot fileDetails) {
        return new FileHashSnapshot(this.hasher.hash(file, fileDetails), fileDetails.getLastModified());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileVisitorImpl
    implements FileVisitor {
        private final List<FileSnapshot> fileTreeElements;

        FileVisitorImpl(List<FileSnapshot> fileTreeElements) {
            this.fileTreeElements = fileTreeElements;
        }

        public void visitDir(FileVisitDetails dirDetails) {
            this.fileTreeElements.add(new DirectoryFileSnapshot(DefaultFileSystemSnapshotter.this.internPath(dirDetails.getFile()), dirDetails.getRelativePath(), false));
        }

        public void visitFile(FileVisitDetails fileDetails) {
            this.fileTreeElements.add(new RegularFileSnapshot(DefaultFileSystemSnapshotter.this.internPath(fileDetails.getFile()), fileDetails.getRelativePath(), false, DefaultFileSystemSnapshotter.this.fileSnapshot((FileTreeElement)fileDetails)));
        }
    }

    private static class HashBackedSnapshot
    implements Snapshot {
        private final HashCode hashCode;

        HashBackedSnapshot(HashCode hashCode) {
            this.hashCode = hashCode;
        }

        public void appendToHasher(BuildCacheHasher hasher) {
            hasher.putHash(this.hashCode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashBackedSnapshot that = (HashBackedSnapshot)o;
            return this.hashCode.equals((Object)that.hashCode);
        }

        public int hashCode() {
            return this.hashCode.hashCode();
        }
    }
}

