/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/CoroutineContextFIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/FunctionIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Intrinsic", "js.translator"})
public final class CoroutineContextFIF
implements FunctionIntrinsicFactory {
    public static final CoroutineContextFIF INSTANCE;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (!CoroutineCallCheckerKt.isBuiltInCoroutineContext(descriptor2)) {
            return null;
        }
        return Intrinsic.INSTANCE;
    }

    private CoroutineContextFIF() {
    }

    static {
        CoroutineContextFIF coroutineContextFIF;
        INSTANCE = coroutineContextFIF = new CoroutineContextFIF();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/CoroutineContextFIF$Intrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    public static final class Intrinsic
    extends FunctionIntrinsic {
        public static final Intrinsic INSTANCE;

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            VariableDescriptor continuation;
            Intrinsics.checkParameterIsNotNull((Object)callInfo, (String)"callInfo");
            Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            VariableDescriptor variableDescriptor = continuation = TranslationUtils.getEnclosingContinuationParameter(context);
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor, (String)"continuation");
            ClassifierDescriptor classifierDescriptor = variableDescriptor.getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                String string = "Continuation is not a class";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ClassDescriptor continuationDescriptor = classDescriptor;
            PropertyDescriptor contContext = DescriptorUtils.getPropertyByName(continuationDescriptor.getUnsubstitutedMemberScope(), Name.identifier("context"));
            DeclarationDescriptor declarationDescriptor = context.getDeclarationDescriptor();
            JsNameRef res2 = new JsNameRef(context.getNameForDescriptor(contContext), declarationDescriptor != null && DescriptorUtilsKt.isCoroutineLambda(declarationDescriptor) ? JsAstUtils.stateMachineReceiver() : TranslationUtils.translateContinuationArgument(context));
            MetadataProperties.setInlineStrategy(res2, InlineStrategy.NOT_INLINE);
            return res2;
        }

        private Intrinsic() {
        }

        static {
            Intrinsic intrinsic;
            INSTANCE = intrinsic = new Intrinsic();
        }
    }
}

