/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.util.ConfigureUtil;

public class DefaultScalaSourceSet
implements ScalaSourceSet,
HasPublicType {
    private final SourceDirectorySet scala;
    private final SourceDirectorySet allScala;

    public DefaultScalaSourceSet(String displayName, SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.scala = sourceDirectorySetFactory.create("scala", displayName + " Scala source");
        this.scala.getFilter().include(new String[]{"**/*.java", "**/*.scala"});
        this.allScala = sourceDirectorySetFactory.create(displayName + " Scala source");
        this.allScala.getFilter().include(new String[]{"**/*.scala"});
        this.allScala.source(this.scala);
    }

    @Override
    public SourceDirectorySet getScala() {
        return this.scala;
    }

    @Override
    public ScalaSourceSet scala(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getScala());
        return this;
    }

    @Override
    public ScalaSourceSet scala(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute((Object)this.getScala());
        return this;
    }

    @Override
    public SourceDirectorySet getAllScala() {
        return this.allScala;
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(ScalaSourceSet.class);
    }
}

