/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.operations.StyledTextBuildOperationProgressDetails;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.OperationIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledTextOutputEvent
extends RenderableOutputEvent
implements StyledTextBuildOperationProgressDetails {
    public static final Span EOL = new Span(SystemProperties.getInstance().getLineSeparator());
    private final List<Span> spans;

    public StyledTextOutputEvent(long timestamp, String category, LogLevel logLevel, @Nullable OperationIdentifier buildOperationIdentifier, String text) {
        this(timestamp, category, logLevel, buildOperationIdentifier, Collections.singletonList(new Span(StyledTextOutput.Style.Normal, text)));
    }

    public StyledTextOutputEvent(long timestamp, String category, LogLevel logLevel, @Nullable OperationIdentifier buildOperationIdentifier, List<Span> spans) {
        super(timestamp, category, logLevel, buildOperationIdentifier);
        this.spans = new ArrayList<Span>(spans);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[').append((Object)this.getLogLevel()).append("] [");
        builder.append(this.getCategory()).append("] ");
        for (Span span : this.spans) {
            builder.append('<');
            builder.append((Object)span.style);
            builder.append(">");
            builder.append(span.text);
            builder.append("</");
            builder.append((Object)span.style);
            builder.append(">");
        }
        return builder.toString();
    }

    public StyledTextOutputEvent withLogLevel(LogLevel logLevel) {
        return new StyledTextOutputEvent(this.getTimestamp(), this.getCategory(), logLevel, this.getBuildOperationId(), this.spans);
    }

    public List<Span> getSpans() {
        return this.spans;
    }

    @Override
    public void render(StyledTextOutput output) {
        for (Span span : this.spans) {
            output.style(span.style);
            output.text(span.text);
        }
    }

    public static class Span
    implements StyledTextBuildOperationProgressDetails.Span,
    Serializable {
        private final String text;
        private final StyledTextOutput.Style style;

        public Span(StyledTextOutput.Style style, String text) {
            this.style = style;
            this.text = text;
        }

        public Span(String text) {
            this.style = StyledTextOutput.Style.Normal;
            this.text = text;
        }

        public StyledTextOutput.Style getStyle() {
            return this.style;
        }

        public String getStyleName() {
            return this.getStyle().name();
        }

        public String getText() {
            return this.text;
        }
    }
}

