/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.logging.console.ProgressOperation;
import org.gradle.internal.operations.OperationIdentifier;

public class ProgressOperations {
    private final Map<OperationIdentifier, ProgressOperation> operationsById = new HashMap<OperationIdentifier, ProgressOperation>();

    public ProgressOperation start(String description, String status, String category, OperationIdentifier operationId, @Nullable OperationIdentifier parentOperationId) {
        ProgressOperation parent = null;
        if (parentOperationId != null) {
            parent = this.operationsById.get(parentOperationId);
        }
        ProgressOperation operation = new ProgressOperation(description, status, category, operationId, parent);
        if (parent != null) {
            parent.addChild(operation);
        }
        this.operationsById.put(operationId, operation);
        return operation;
    }

    public ProgressOperation progress(String description, OperationIdentifier operationId) {
        ProgressOperation op = this.operationsById.get(operationId);
        if (op == null) {
            throw new IllegalStateException("Received progress event for an unknown operation (id: " + operationId + ")");
        }
        op.setStatus(description);
        return op;
    }

    public ProgressOperation complete(OperationIdentifier operationId) {
        ProgressOperation op = this.operationsById.remove(operationId);
        if (op == null) {
            throw new IllegalStateException("Received complete event for an unknown operation (id: " + operationId + ")");
        }
        if (op.getParent() != null) {
            op.getParent().removeChild(op);
        }
        return op;
    }
}

