/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.annotation.Annotation;
import java.util.List;
import org.gradle.model.Each;
import org.gradle.model.Path;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuleApplicationScope
extends Enum<RuleApplicationScope> {
    public static final /* enum */ RuleApplicationScope SELF = new RuleApplicationScope();
    public static final /* enum */ RuleApplicationScope DESCENDANTS = new RuleApplicationScope();
    private static final /* synthetic */ RuleApplicationScope[] $VALUES;

    public static RuleApplicationScope[] values() {
        return (RuleApplicationScope[])$VALUES.clone();
    }

    public static RuleApplicationScope valueOf(String name) {
        return Enum.valueOf(RuleApplicationScope.class, name);
    }

    public static RuleApplicationScope fromRuleDefinition(RuleSourceValidationProblemCollector problems, MethodRuleDefinition<?, ?> ruleDefinition, int subjectParamIndex) {
        List<List<Annotation>> parameterAnnotations = ruleDefinition.getParameterAnnotations();
        if (subjectParamIndex >= parameterAnnotations.size()) {
            throw new IndexOutOfBoundsException("Rule definition should have at least " + (subjectParamIndex + 1) + " parameters");
        }
        RuleApplicationScope result = null;
        for (int paramIndex = 0; paramIndex < parameterAnnotations.size(); ++paramIndex) {
            List<Annotation> annotations = parameterAnnotations.get(paramIndex);
            boolean annotatedWithEach = RuleApplicationScope.hasAnnotation(annotations, Each.class);
            if (paramIndex == subjectParamIndex) {
                if (annotatedWithEach && RuleApplicationScope.hasAnnotation(annotations, Path.class)) {
                    problems.add(ruleDefinition, "Rule subject must not be annotated with both @Path and @Each.");
                }
                result = annotatedWithEach ? DESCENDANTS : SELF;
                continue;
            }
            if (!annotatedWithEach) continue;
            problems.add(ruleDefinition, String.format("Rule parameter #%d should not be annotated with @Each.", paramIndex + 1));
        }
        assert (result != null);
        return result;
    }

    private static boolean hasAnnotation(Iterable<Annotation> annotations, Class<? extends Annotation> annotationType) {
        for (Annotation annotation : annotations) {
            if (!annotationType.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    static {
        $VALUES = new RuleApplicationScope[]{SELF, DESCENDANTS};
    }
}

