/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DefaultExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.IvyDependencyDescriptor;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ModuleMetadataSerializer {
    private static final byte TYPE_IVY = 1;
    private static final byte TYPE_MAVEN = 2;
    private final ModuleComponentSelectorSerializer componentSelectorSerializer;
    private final MavenMutableModuleMetadataFactory mavenMetadataFactory;
    private final IvyMutableModuleMetadataFactory ivyMetadataFactory;
    private final AttributeContainerSerializer attributeContainerSerializer;

    public ModuleMetadataSerializer(AttributeContainerSerializer attributeContainerSerializer, MavenMutableModuleMetadataFactory mavenMetadataFactory, IvyMutableModuleMetadataFactory ivyMetadataFactory) {
        this.mavenMetadataFactory = mavenMetadataFactory;
        this.ivyMetadataFactory = ivyMetadataFactory;
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.componentSelectorSerializer = new ModuleComponentSelectorSerializer(attributeContainerSerializer);
    }

    public MutableModuleComponentResolveMetadata read(Decoder decoder, ImmutableModuleIdentifierFactory moduleIdentifierFactory) throws IOException {
        return new Reader(decoder, moduleIdentifierFactory, this.attributeContainerSerializer, this.componentSelectorSerializer, this.mavenMetadataFactory, this.ivyMetadataFactory).read();
    }

    public void write(Encoder encoder, ModuleComponentResolveMetadata metadata) throws IOException {
        new Writer(encoder, this.attributeContainerSerializer, this.componentSelectorSerializer).write(metadata);
    }

    private static class Reader {
        private final Decoder decoder;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final ExcludeRuleConverter excludeRuleConverter;
        private final AttributeContainerSerializer attributeContainerSerializer;
        private final ModuleComponentSelectorSerializer componentSelectorSerializer;
        private final MavenMutableModuleMetadataFactory mavenMetadataFactory;
        private final IvyMutableModuleMetadataFactory ivyMetadataFactory;
        private ModuleComponentIdentifier id;
        private ImmutableAttributes attributes;

        private Reader(Decoder decoder, ImmutableModuleIdentifierFactory moduleIdentifierFactory, AttributeContainerSerializer attributeContainerSerializer, ModuleComponentSelectorSerializer componentSelectorSerializer, MavenMutableModuleMetadataFactory mavenMutableModuleMetadataFactory, IvyMutableModuleMetadataFactory ivyMetadataFactory) {
            this.decoder = decoder;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.excludeRuleConverter = new DefaultExcludeRuleConverter(moduleIdentifierFactory);
            this.attributeContainerSerializer = attributeContainerSerializer;
            this.componentSelectorSerializer = componentSelectorSerializer;
            this.mavenMetadataFactory = mavenMutableModuleMetadataFactory;
            this.ivyMetadataFactory = ivyMetadataFactory;
        }

        public MutableModuleComponentResolveMetadata read() throws IOException {
            byte type = this.decoder.readByte();
            switch (type) {
                case 1: {
                    return this.readIvy();
                }
                case 2: {
                    return this.readMaven();
                }
            }
            throw new IllegalArgumentException("Unexpected metadata type found.");
        }

        private void readSharedInfo(MutableModuleComponentResolveMetadata metadata) throws IOException {
            metadata.setContentHash(new HashValue(this.decoder.readBinary()));
            metadata.setMissing(this.decoder.readBoolean());
            metadata.setStatus(this.decoder.readString());
        }

        private MutableModuleComponentResolveMetadata readMaven() throws IOException {
            this.readInfoSection();
            String snapshotTimestamp = this.readNullableString();
            if (snapshotTimestamp != null) {
                this.id = new MavenUniqueSnapshotComponentIdentifier(this.id, snapshotTimestamp);
            }
            List<MavenDependencyDescriptor> dependencies = this.readMavenDependencies();
            MutableMavenModuleResolveMetadata metadata = this.mavenMetadataFactory.create(this.id, dependencies);
            this.readSharedInfo(metadata);
            metadata.setSnapshotTimestamp(snapshotTimestamp);
            metadata.setPackaging(this.readNullableString());
            metadata.setRelocated(this.readBoolean());
            metadata.setAttributes((AttributeContainer)this.attributes);
            this.readVariants(metadata);
            return metadata;
        }

        private void readVariants(MutableModuleComponentResolveMetadata metadata) throws IOException {
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                String name = this.decoder.readString();
                ImmutableAttributes attributes = this.readAttributes();
                MutableComponentVariant variant = metadata.addVariant(name, attributes);
                this.readVariantDependencies(variant);
                this.readVariantConstraints(variant);
                this.readVariantFiles(variant);
                this.readVariantCapabilities(variant);
            }
        }

        private ImmutableAttributes readAttributes() throws IOException {
            return this.attributeContainerSerializer.read(this.decoder);
        }

        private void readVariantDependencies(MutableComponentVariant variant) throws IOException {
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                ModuleComponentSelector selector = this.componentSelectorSerializer.read(this.decoder);
                String reason = this.decoder.readNullableString();
                ImmutableList<ExcludeMetadata> excludes = this.readVariantDependencyExcludes();
                variant.addDependency(selector.getGroup(), selector.getModule(), selector.getVersionConstraint(), (List<ExcludeMetadata>)excludes, reason, (ImmutableAttributes)selector.getAttributes());
            }
        }

        private void readVariantConstraints(MutableComponentVariant variant) throws IOException {
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                ModuleComponentSelector selector = this.componentSelectorSerializer.read(this.decoder);
                String reason = this.decoder.readNullableString();
                variant.addDependencyConstraint(selector.getGroup(), selector.getModule(), selector.getVersionConstraint(), reason, (ImmutableAttributes)selector.getAttributes());
            }
        }

        private ImmutableList<ExcludeMetadata> readVariantDependencyExcludes() throws IOException {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            int len = this.readCount();
            for (int i = 0; i < len; ++i) {
                String group = this.readString();
                String module = this.readString();
                builder.add((Object)this.excludeRuleConverter.createExcludeRule(group, module));
            }
            return builder.build();
        }

        private void readVariantFiles(MutableComponentVariant variant) throws IOException {
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                variant.addFile(this.decoder.readString(), this.decoder.readString());
            }
        }

        private void readVariantCapabilities(MutableComponentVariant variant) throws IOException {
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                variant.addCapability(this.decoder.readString(), this.decoder.readString(), this.decoder.readString());
            }
        }

        private MutableModuleComponentResolveMetadata readIvy() throws IOException {
            this.readInfoSection();
            Map<NamespaceId, String> extraAttributes = this.readExtraInfo();
            List<Configuration> configurations = this.readConfigurations();
            List<IvyDependencyDescriptor> dependencies = this.readIvyDependencies();
            List<Artifact> artifacts = this.readArtifacts();
            List<Exclude> excludes = this.readModuleExcludes();
            MutableIvyModuleResolveMetadata metadata = this.ivyMetadataFactory.create(this.id, dependencies, configurations, artifacts, excludes);
            this.readSharedInfo(metadata);
            String branch = this.readNullableString();
            metadata.setBranch(branch);
            metadata.setExtraAttributes(extraAttributes);
            metadata.setAttributes((AttributeContainer)this.attributes);
            this.readVariants(metadata);
            return metadata;
        }

        private void readInfoSection() throws IOException {
            this.id = this.readId();
            this.attributes = this.readAttributes();
        }

        private ModuleComponentIdentifier readId() throws IOException {
            return DefaultModuleComponentIdentifier.newId(this.readString(), this.readString(), this.readString());
        }

        private Map<NamespaceId, String> readExtraInfo() throws IOException {
            int len = this.readCount();
            LinkedHashMap<NamespaceId, String> result = new LinkedHashMap<NamespaceId, String>(len);
            for (int i = 0; i < len; ++i) {
                NamespaceId namespaceId = new NamespaceId(this.readString(), this.readString());
                String value = this.readString();
                result.put(namespaceId, value);
            }
            return result;
        }

        private List<Configuration> readConfigurations() throws IOException {
            int len = this.readCount();
            ArrayList<Configuration> configurations = new ArrayList<Configuration>(len);
            for (int i = 0; i < len; ++i) {
                Configuration configuration = this.readConfiguration();
                configurations.add(configuration);
            }
            return configurations;
        }

        private Configuration readConfiguration() throws IOException {
            String name = this.readString();
            boolean transitive = this.readBoolean();
            boolean visible = this.readBoolean();
            List<String> extendsFrom = this.readStringList();
            return new Configuration(name, transitive, visible, extendsFrom);
        }

        private List<Artifact> readArtifacts() throws IOException {
            int size = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.readString(), this.readString(), this.readNullableString(), this.readNullableString());
                result.add(new Artifact(ivyArtifactName, this.readStringSet()));
            }
            return result;
        }

        private List<IvyDependencyDescriptor> readIvyDependencies() throws IOException {
            int len = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                result.add(this.readIvyDependency());
            }
            return result;
        }

        private IvyDependencyDescriptor readIvyDependency() throws IOException {
            ModuleComponentSelector requested = this.componentSelectorSerializer.read(this.decoder);
            SetMultimap<String, String> configMappings = this.readDependencyConfigurationMapping();
            List<Artifact> artifacts = this.readDependencyArtifactDescriptors();
            List<Exclude> excludes = this.readDependencyExcludes();
            String dynamicConstraintVersion = this.readString();
            boolean changing = this.readBoolean();
            boolean transitive = this.readBoolean();
            boolean optional = this.readBoolean();
            return new IvyDependencyDescriptor(requested, dynamicConstraintVersion, changing, transitive, optional, (Multimap<String, String>)configMappings, artifacts, excludes);
        }

        private SetMultimap<String, String> readDependencyConfigurationMapping() throws IOException {
            int size = this.readCount();
            LinkedHashMultimap result = LinkedHashMultimap.create();
            for (int i = 0; i < size; ++i) {
                String from = this.readString();
                Set<String> to = this.readStringSet();
                result.putAll((Object)from, to);
            }
            return result;
        }

        private List<Artifact> readDependencyArtifactDescriptors() throws IOException {
            int size = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.readString(), this.readString(), this.readNullableString(), this.readNullableString());
                result.add(new Artifact(ivyArtifactName, this.readStringSet()));
            }
            return result;
        }

        private List<Exclude> readDependencyExcludes() throws IOException {
            int len = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                DefaultExclude rule = this.readExcludeRule();
                result.add(rule);
            }
            return result;
        }

        private List<Exclude> readModuleExcludes() throws IOException {
            int len = this.readCount();
            ArrayList<Exclude> result = new ArrayList<Exclude>(len);
            for (int i = 0; i < len; ++i) {
                result.add(this.readExcludeRule());
            }
            return result;
        }

        private DefaultExclude readExcludeRule() throws IOException {
            String moduleOrg = this.readString();
            String moduleName = this.readString();
            IvyArtifactName artifactName = this.readNullableArtifact();
            String[] confs = this.readStringArray();
            String matcher = this.readNullableString();
            return new DefaultExclude(this.moduleIdentifierFactory.module(moduleOrg, moduleName), artifactName, confs, matcher);
        }

        private IvyArtifactName readNullableArtifact() throws IOException {
            boolean hasArtifact = this.readBoolean();
            DefaultIvyArtifactName artifactName = null;
            if (hasArtifact) {
                String artifact = this.readString();
                String type = this.readString();
                String ext = this.readNullableString();
                String classifier = this.readNullableString();
                artifactName = new DefaultIvyArtifactName(artifact, type, ext, classifier);
            }
            return artifactName;
        }

        private List<MavenDependencyDescriptor> readMavenDependencies() throws IOException {
            int len = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                result.add(this.readMavenDependency());
            }
            return result;
        }

        private MavenDependencyDescriptor readMavenDependency() throws IOException {
            ModuleComponentSelector requested = this.componentSelectorSerializer.read(this.decoder);
            IvyArtifactName artifactName = this.readNullableArtifact();
            List<ExcludeMetadata> mavenExcludes = this.readMavenDependencyExcludes();
            MavenScope scope = MavenScope.values()[this.decoder.readSmallInt()];
            boolean optional = this.decoder.readBoolean();
            return new MavenDependencyDescriptor(scope, optional, requested, artifactName, mavenExcludes);
        }

        private List<ExcludeMetadata> readMavenDependencyExcludes() throws IOException {
            int len = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                String moduleOrg = this.readString();
                String moduleName = this.readString();
                DefaultExclude rule = new DefaultExclude(this.moduleIdentifierFactory.module(moduleOrg, moduleName));
                result.add(rule);
            }
            return result;
        }

        private int readCount() throws IOException {
            return this.decoder.readSmallInt();
        }

        private String readString() throws IOException {
            return this.decoder.readString();
        }

        private String readNullableString() throws IOException {
            return this.decoder.readNullableString();
        }

        private boolean readBoolean() throws IOException {
            return this.decoder.readBoolean();
        }

        private String[] readStringArray() throws IOException {
            int size = this.readCount();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.readNullableString();
            }
            return array;
        }

        private List<String> readStringList() throws IOException {
            int size = this.readCount();
            ArrayList<String> list = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.readString());
            }
            return list;
        }

        private Set<String> readStringSet() throws IOException {
            int size = this.readCount();
            LinkedHashSet<String> set = new LinkedHashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                set.add(this.readString());
            }
            return set;
        }
    }

    private static class Writer {
        private final Encoder encoder;
        private final AttributeContainerSerializer attributeContainerSerializer;
        private final ModuleComponentSelectorSerializer componentSelectorSerializer;

        private Writer(Encoder encoder, AttributeContainerSerializer attributeContainerSerializer, ModuleComponentSelectorSerializer componentSelectorSerializer) {
            this.encoder = encoder;
            this.attributeContainerSerializer = attributeContainerSerializer;
            this.componentSelectorSerializer = componentSelectorSerializer;
        }

        public void write(ModuleComponentResolveMetadata metadata) throws IOException {
            if (metadata instanceof IvyModuleResolveMetadata) {
                this.write((IvyModuleResolveMetadata)metadata);
            } else if (metadata instanceof MavenModuleResolveMetadata) {
                this.write((MavenModuleResolveMetadata)metadata);
            } else {
                throw new IllegalArgumentException("Unexpected metadata type: " + metadata.getClass());
            }
        }

        private void write(MavenModuleResolveMetadata metadata) throws IOException {
            this.encoder.writeByte((byte)2);
            this.writeInfoSection(metadata);
            this.writeNullableString(metadata.getSnapshotTimestamp());
            this.writeMavenDependencies((List<MavenDependencyDescriptor>)metadata.getDependencies());
            this.writeSharedInfo(metadata);
            this.writeNullableString(metadata.getPackaging());
            this.writeBoolean(metadata.isRelocated());
            this.writeVariants(metadata);
        }

        private void writeVariants(ModuleComponentResolveMetadata metadata) throws IOException {
            this.encoder.writeSmallInt(metadata.getVariants().size());
            for (ComponentVariant variant : metadata.getVariants()) {
                this.encoder.writeString((CharSequence)variant.getName());
                this.writeAttributes((AttributeContainer)variant.getAttributes());
                this.writeVariantDependencies((List<? extends ComponentVariant.Dependency>)variant.getDependencies());
                this.writeVariantConstraints(variant.getDependencyConstraints());
                this.writeVariantFiles((List<? extends ComponentVariant.File>)variant.getFiles());
                this.writeVariantCapabilities(variant.getCapabilities().getCapabilities());
            }
        }

        private void writeVariantConstraints(ImmutableList<? extends ComponentVariant.DependencyConstraint> constraints) throws IOException {
            this.encoder.writeSmallInt(constraints.size());
            for (ComponentVariant.DependencyConstraint constraint : constraints) {
                this.componentSelectorSerializer.write(this.encoder, constraint.getGroup(), constraint.getModule(), constraint.getVersionConstraint(), constraint.getAttributes());
                this.encoder.writeNullableString((CharSequence)constraint.getReason());
            }
        }

        private void writeVariantDependencies(List<? extends ComponentVariant.Dependency> dependencies) throws IOException {
            this.encoder.writeSmallInt(dependencies.size());
            for (ComponentVariant.Dependency dependency : dependencies) {
                this.componentSelectorSerializer.write(this.encoder, dependency.getGroup(), dependency.getModule(), dependency.getVersionConstraint(), dependency.getAttributes());
                this.encoder.writeNullableString((CharSequence)dependency.getReason());
                this.writeVariantDependencyExcludes((List<ExcludeMetadata>)dependency.getExcludes());
            }
        }

        private void writeVariantDependencyExcludes(List<ExcludeMetadata> excludes) throws IOException {
            this.writeCount(excludes.size());
            for (ExcludeMetadata exclude : excludes) {
                this.writeString(exclude.getModuleId().getGroup());
                this.writeString(exclude.getModuleId().getName());
            }
        }

        private void writeAttributes(AttributeContainer attributes) throws IOException {
            this.attributeContainerSerializer.write(this.encoder, attributes);
        }

        private void writeVariantFiles(List<? extends ComponentVariant.File> files) throws IOException {
            this.encoder.writeSmallInt(files.size());
            for (ComponentVariant.File file : files) {
                this.encoder.writeString((CharSequence)file.getName());
                this.encoder.writeString((CharSequence)file.getUri());
            }
        }

        private void writeVariantCapabilities(List<? extends Capability> capabilities) throws IOException {
            this.encoder.writeSmallInt(capabilities.size());
            for (Capability capability : capabilities) {
                this.encoder.writeString((CharSequence)capability.getGroup());
                this.encoder.writeString((CharSequence)capability.getName());
                this.encoder.writeString((CharSequence)capability.getVersion());
            }
        }

        private void write(IvyModuleResolveMetadata metadata) throws IOException {
            this.encoder.writeByte((byte)1);
            this.writeInfoSection(metadata);
            this.writeExtraInfo((Map<NamespaceId, String>)metadata.getExtraAttributes());
            this.writeConfigurations((Collection<Configuration>)metadata.getConfigurationDefinitions().values());
            this.writeIvyDependencies((List<IvyDependencyDescriptor>)metadata.getDependencies());
            this.writeArtifacts((List<Artifact>)metadata.getArtifactDefinitions());
            this.writeExcludeRules((List<Exclude>)metadata.getExcludes());
            this.writeSharedInfo(metadata);
            this.writeNullableString(metadata.getBranch());
            this.writeVariants(metadata);
        }

        private void writeSharedInfo(ModuleComponentResolveMetadata metadata) throws IOException {
            this.encoder.writeBinary(metadata.getContentHash().asByteArray());
            this.encoder.writeBoolean(metadata.isMissing());
            this.encoder.writeString((CharSequence)metadata.getStatus());
        }

        private void writeId(ModuleComponentIdentifier componentIdentifier) throws IOException {
            this.writeString(componentIdentifier.getGroup());
            this.writeString(componentIdentifier.getModule());
            this.writeString(componentIdentifier.getVersion());
        }

        private void writeInfoSection(ModuleComponentResolveMetadata metadata) throws IOException {
            this.writeId(metadata.getId());
            this.writeAttributes(metadata.getAttributes());
        }

        private void writeExtraInfo(Map<NamespaceId, String> extraInfo) throws IOException {
            this.writeCount(extraInfo.size());
            for (Map.Entry<NamespaceId, String> entry : extraInfo.entrySet()) {
                NamespaceId namespaceId = entry.getKey();
                this.writeString(namespaceId.getNamespace());
                this.writeString(namespaceId.getName());
                this.writeString(entry.getValue());
            }
        }

        private void writeConfigurations(Collection<Configuration> configurations) throws IOException {
            this.writeCount(configurations.size());
            for (Configuration conf : configurations) {
                this.writeConfiguration(conf);
            }
        }

        private void writeConfiguration(Configuration conf) throws IOException {
            this.writeString(conf.getName());
            this.writeBoolean(conf.isTransitive());
            this.writeBoolean(conf.isVisible());
            this.writeStringList(conf.getExtendsFrom());
        }

        private void writeArtifacts(List<Artifact> artifacts) throws IOException {
            this.writeCount(artifacts.size());
            for (Artifact artifact : artifacts) {
                IvyArtifactName artifactName = artifact.getArtifactName();
                this.writeString(artifactName.getName());
                this.writeString(artifactName.getType());
                this.writeNullableString(artifactName.getExtension());
                this.writeNullableString(artifactName.getClassifier());
                this.writeStringSet(artifact.getConfigurations());
            }
        }

        private void writeIvyDependencies(List<IvyDependencyDescriptor> dependencies) throws IOException {
            this.writeCount(dependencies.size());
            for (IvyDependencyDescriptor dd : dependencies) {
                this.writeIvyDependency(dd);
            }
        }

        private void writeMavenDependencies(List<MavenDependencyDescriptor> dependencies) throws IOException {
            this.writeCount(dependencies.size());
            for (MavenDependencyDescriptor dd : dependencies) {
                this.writeMavenDependency(dd);
            }
        }

        private void writeIvyDependency(IvyDependencyDescriptor ivyDependency) throws IOException {
            this.componentSelectorSerializer.write(this.encoder, ivyDependency.getSelector());
            this.writeDependencyConfigurationMapping(ivyDependency);
            this.writeArtifacts(ivyDependency.getDependencyArtifacts());
            this.writeExcludeRules(ivyDependency.getAllExcludes());
            this.writeString(ivyDependency.getDynamicConstraintVersion());
            this.writeBoolean(ivyDependency.isChanging());
            this.writeBoolean(ivyDependency.isTransitive());
            this.writeBoolean(ivyDependency.isOptional());
        }

        private void writeDependencyConfigurationMapping(IvyDependencyDescriptor dep) throws IOException {
            SetMultimap<String, String> confMappings = dep.getConfMappings();
            this.writeCount(confMappings.keySet().size());
            for (String conf : confMappings.keySet()) {
                this.writeString(conf);
                this.writeStringSet(confMappings.get((Object)conf));
            }
        }

        private void writeExcludeRules(List<Exclude> excludes) throws IOException {
            this.writeCount(excludes.size());
            for (Exclude exclude : excludes) {
                this.writeString(exclude.getModuleId().getGroup());
                this.writeString(exclude.getModuleId().getName());
                IvyArtifactName artifact = exclude.getArtifact();
                this.writeNullableArtifact(artifact);
                this.writeStringArray(exclude.getConfigurations().toArray(new String[0]));
                this.writeNullableString(exclude.getMatcher());
            }
        }

        private void writeMavenDependency(MavenDependencyDescriptor mavenDependency) throws IOException {
            this.componentSelectorSerializer.write(this.encoder, mavenDependency.getSelector());
            this.writeNullableArtifact(mavenDependency.getDependencyArtifact());
            this.writeMavenExcludeRules(mavenDependency.getAllExcludes());
            this.encoder.writeSmallInt(mavenDependency.getScope().ordinal());
            this.encoder.writeBoolean(mavenDependency.isOptional());
        }

        private void writeNullableArtifact(IvyArtifactName artifact) throws IOException {
            if (artifact == null) {
                this.writeBoolean(false);
            } else {
                this.writeBoolean(true);
                this.writeString(artifact.getName());
                this.writeString(artifact.getType());
                this.writeNullableString(artifact.getExtension());
                this.writeNullableString(artifact.getClassifier());
            }
        }

        private void writeMavenExcludeRules(List<ExcludeMetadata> excludes) throws IOException {
            this.writeCount(excludes.size());
            for (ExcludeMetadata exclude : excludes) {
                this.writeString(exclude.getModuleId().getGroup());
                this.writeString(exclude.getModuleId().getName());
            }
        }

        private void writeCount(int i) throws IOException {
            this.encoder.writeSmallInt(i);
        }

        private void writeString(String str) throws IOException {
            this.encoder.writeString((CharSequence)str);
        }

        private void writeNullableString(String str) throws IOException {
            this.encoder.writeNullableString((CharSequence)str);
        }

        private void writeBoolean(boolean b) throws IOException {
            this.encoder.writeBoolean(b);
        }

        private void writeStringArray(String[] values) throws IOException {
            this.writeCount(values.length);
            for (String configuration : values) {
                this.writeNullableString(configuration);
            }
        }

        private void writeStringList(List<String> values) throws IOException {
            this.writeCount(values.size());
            for (String configuration : values) {
                this.writeString(configuration);
            }
        }

        private void writeStringSet(Set<String> values) throws IOException {
            this.writeCount(values.size());
            for (String configuration : values) {
                this.writeString(configuration);
            }
        }
    }
}

