/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoaderUtils {
    private static final ClassDefiner CLASS_DEFINER = JavaVersion.current().isJava9Compatible() ? new LookupClassDefiner() : new ReflectionClassDefiner();
    private static final JavaMethod<ClassLoader, Package[]> GET_PACKAGES_METHOD = ClassLoaderUtils.getMethodWithFallback(Package[].class, new Class[0], "getDefinedPackages", "getPackages");
    private static final JavaMethod<ClassLoader, Package> GET_PACKAGE_METHOD = ClassLoaderUtils.getMethodWithFallback(Package.class, new Class[]{String.class}, "getDefinedPackage", "getPackage");

    private static <T> JavaMethod<ClassLoader, T> getMethodWithFallback(Class<T> clazz, Class<?>[] params, String firstChoice, String fallback) {
        JavaMethod<Class<ClassLoader>, T> method;
        try {
            method = JavaReflectionUtil.method(ClassLoader.class, clazz, firstChoice, params);
        }
        catch (Throwable e) {
            method = JavaReflectionUtil.method(ClassLoader.class, clazz, fallback, params);
        }
        return method;
    }

    public static ClassLoader getPlatformClassLoader() {
        return ClassLoader.getSystemClassLoader().getParent();
    }

    public static void tryClose(@Nullable ClassLoader classLoader) {
        CompositeStoppable.stoppable(classLoader).stop();
    }

    public static void disableUrlConnectionCaching() {
        try {
            URL url = new URL("jar:file://valid_jar_url_syntax.jar!/");
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static JavaMethod<ClassLoader, Package[]> getPackagesMethod() {
        return GET_PACKAGES_METHOD;
    }

    public static JavaMethod<ClassLoader, Package> getPackageMethod() {
        return GET_PACKAGE_METHOD;
    }

    public static <T> Class<T> define(ClassLoader targetClassLoader, String className, byte[] clazzBytes) {
        return CLASS_DEFINER.defineClass(targetClassLoader, className, clazzBytes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupClassDefiner
    implements ClassDefiner {
        private final Class methodHandlesLookupClass;
        private final JavaMethod methodHandlesLookup;
        private final JavaMethod methodHandlesPrivateLookupIn;
        private final JavaMethod lookupFindVirtual;
        private final MethodType defineClassMethodType;

        private LookupClassDefiner() {
            try {
                this.methodHandlesLookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.methodHandlesLookup = JavaReflectionUtil.staticMethod(MethodHandles.class, this.methodHandlesLookupClass, "lookup", new Class[0]);
            this.methodHandlesPrivateLookupIn = JavaReflectionUtil.staticMethod(MethodHandles.class, this.methodHandlesLookupClass, "privateLookupIn", Class.class, this.methodHandlesLookupClass);
            this.lookupFindVirtual = JavaReflectionUtil.method(this.methodHandlesLookupClass, MethodHandle.class, "findVirtual", new Class[]{Class.class, String.class, MethodType.class});
            this.defineClassMethodType = MethodType.methodType(Class.class, new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
        }

        @Override
        public <T> Class<T> defineClass(ClassLoader classLoader, String className, byte[] classBytes) {
            Object baseLookup = this.methodHandlesLookup.invoke(null, new Object[0]);
            Object lookup = this.methodHandlesPrivateLookupIn.invoke(null, ClassLoader.class, baseLookup);
            MethodHandle defineClassMethodHandle = (MethodHandle)this.lookupFindVirtual.invoke(lookup, ClassLoader.class, "defineClass", this.defineClassMethodType);
            try {
                return (Class)Cast.uncheckedCast(defineClassMethodHandle.bindTo(classLoader).invokeWithArguments(className, classBytes, 0, classBytes.length));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReflectionClassDefiner
    implements ClassDefiner {
        private final JavaMethod<ClassLoader, Class> defineClassMethod = JavaReflectionUtil.method(ClassLoader.class, Class.class, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});

        private ReflectionClassDefiner() {
        }

        @Override
        public <T> Class<T> defineClass(ClassLoader classLoader, String className, byte[] classBytes) {
            return (Class)Cast.uncheckedCast(this.defineClassMethod.invoke(classLoader, className, classBytes, 0, classBytes.length));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ClassDefiner {
        public <T> Class<T> defineClass(ClassLoader var1, String var2, byte[] var3);
    }
}

