/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.MutableClassDetails;
import org.gradle.internal.reflect.PropertyAccessorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInspector {
    public static ClassDetails inspect(Class<?> type) {
        MutableClassDetails classDetails = new MutableClassDetails(type);
        ClassInspector.visitGraph(type, classDetails);
        return classDetails;
    }

    private static void visitGraph(Class<?> type, MutableClassDetails classDetails) {
        HashSet<Class> seen = new HashSet<Class>();
        ArrayList queue = new ArrayList();
        queue.add(type);
        Collections.addAll(queue, ClassInspector.superClasses(type));
        while (!queue.isEmpty()) {
            Class current = (Class)queue.remove(0);
            if (!seen.add(current)) continue;
            if (!current.equals(type)) {
                classDetails.superType(current);
            }
            ClassInspector.inspectClass(current, classDetails);
            Collections.addAll(queue, current.getInterfaces());
        }
    }

    private static Class<?>[] superClasses(Class<?> current) {
        ArrayList supers = Lists.newArrayList();
        for (Class<?> superclass = current.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
            supers.add(superclass);
        }
        return supers.toArray(new Class[0]);
    }

    private static void inspectClass(Class<?> type, MutableClassDetails classDetails) {
        for (Method method : type.getDeclaredMethods()) {
            String propertyName;
            classDetails.method(method);
            if (Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isBridge()) continue;
            PropertyAccessorType accessorType = PropertyAccessorType.of(method);
            if (accessorType == PropertyAccessorType.GET_GETTER || accessorType == PropertyAccessorType.IS_GETTER) {
                propertyName = accessorType.propertyNameFor(method);
                classDetails.property(propertyName).addGetter(method);
                continue;
            }
            if (accessorType == PropertyAccessorType.SETTER) {
                propertyName = accessorType.propertyNameFor(method);
                classDetails.property(propertyName).addSetter(method);
                continue;
            }
            classDetails.instanceMethod(method);
        }
    }
}

