/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedScheduledExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionInfo;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionMonitor;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;

public class DaemonHealthStats
implements Stoppable {
    private final DaemonRunningStats runningStats;
    private final ManagedScheduledExecutor scheduler;
    private final GarbageCollectionInfo gcInfo;
    private final GarbageCollectionMonitor gcMonitor;

    public DaemonHealthStats(DaemonRunningStats runningStats, ExecutorFactory executorFactory) {
        this.runningStats = runningStats;
        this.scheduler = executorFactory.createScheduled("Daemon health stats", 1);
        this.gcInfo = new GarbageCollectionInfo();
        this.gcMonitor = new GarbageCollectionMonitor(this.scheduler);
    }

    @VisibleForTesting
    DaemonHealthStats(DaemonRunningStats runningStats, GarbageCollectionInfo gcInfo, GarbageCollectionMonitor gcMonitor) {
        this.runningStats = runningStats;
        this.scheduler = null;
        this.gcInfo = gcInfo;
        this.gcMonitor = gcMonitor;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    GarbageCollectionMonitor getGcMonitor() {
        return this.gcMonitor;
    }

    String getHealthInfo() {
        int nextBuildNum = this.runningStats.getBuildCount() + 1;
        if (nextBuildNum == 1) {
            return this.getFirstBuildHealthInfo();
        }
        return this.getBuildHealthInfo(nextBuildNum);
    }

    private String getFirstBuildHealthInfo() {
        return String.format("Starting build in new daemon [memory: %s]", NumberUtil.formatBytes(Runtime.getRuntime().maxMemory()));
    }

    private String getBuildHealthInfo(int nextBuildNum) {
        if (this.gcMonitor.getGcStrategy() != GarbageCollectorMonitoringStrategy.UNKNOWN) {
            GarbageCollectionStats tenuredStats = this.gcMonitor.getTenuredStats();
            GarbageCollectionStats permgenStats = this.gcMonitor.getPermGenStats();
            String message = String.format("Starting %s build in daemon [uptime: %s, performance: %s%%", NumberUtil.ordinal(nextBuildNum), this.runningStats.getPrettyUpTime(), this.getCurrentPerformance());
            if (tenuredStats.getUsage() > 0) {
                message = message + String.format(", GC rate: %.2f/s, tenured heap usage: %s%% of %s", tenuredStats.getRate(), tenuredStats.getUsage(), NumberUtil.formatBytes(tenuredStats.getMax()));
                if (permgenStats.getUsage() > 0) {
                    message = message + String.format(", perm gen usage: %s%% of %s", permgenStats.getUsage(), NumberUtil.formatBytes(permgenStats.getMax()));
                }
            } else {
                message = message + ", no major garbage collections";
            }
            message = message + "]";
            return message;
        }
        return String.format("Starting %s build in daemon [uptime: %s, performance: %s%%]", NumberUtil.ordinal(nextBuildNum), this.runningStats.getPrettyUpTime(), this.getCurrentPerformance());
    }

    private int getCurrentPerformance() {
        long collectionTime = this.gcInfo.getCollectionTime();
        long allBuildsTime = this.runningStats.getAllBuildsTime();
        if (collectionTime > 0L && collectionTime < allBuildsTime) {
            return 100 - NumberUtil.percentOf(collectionTime, allBuildsTime);
        }
        return 100;
    }
}

