/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Objects;
import groovy.lang.Closure;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultExcludeRuleContainer;
import org.gradle.api.internal.artifacts.dependencies.AbstractDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Actions;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleDependency
extends AbstractDependency
implements ModuleDependency {
    private static final Logger LOG = Logging.getLogger(AbstractModuleDependency.class);
    private ImmutableAttributesFactory attributesFactory;
    private DefaultExcludeRuleContainer excludeRuleContainer = new DefaultExcludeRuleContainer();
    private Set<DependencyArtifact> artifacts = new HashSet<DependencyArtifact>();
    private Action<? super ModuleDependency> onMutate = Actions.doNothing();
    private AttributeContainerInternal attributes;
    @Nullable
    private String configuration;
    private boolean transitive = true;

    protected AbstractModuleDependency(@Nullable String configuration) {
        this.configuration = configuration;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public ModuleDependency setTransitive(boolean transitive) {
        this.validateMutation(this.transitive, transitive);
        this.transitive = transitive;
        return this;
    }

    public String getTargetConfiguration() {
        return this.configuration;
    }

    public void setTargetConfiguration(@Nullable String configuration) {
        this.validateMutation(this.configuration, configuration);
        this.configuration = configuration;
    }

    public ModuleDependency exclude(Map<String, String> excludeProperties) {
        if (this.excludeRuleContainer.maybeAdd(excludeProperties)) {
            this.validateMutation();
        }
        return this;
    }

    public Set<ExcludeRule> getExcludeRules() {
        return this.excludeRuleContainer.getRules();
    }

    private void setExcludeRuleContainer(DefaultExcludeRuleContainer excludeRuleContainer) {
        this.excludeRuleContainer = excludeRuleContainer;
    }

    public Set<DependencyArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Set<DependencyArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    public AbstractModuleDependency addArtifact(DependencyArtifact artifact) {
        this.artifacts.add(artifact);
        return this;
    }

    public DependencyArtifact artifact(Closure configureClosure) {
        return this.artifact(ConfigureUtil.configureUsing(configureClosure));
    }

    public DependencyArtifact artifact(Action<? super DependencyArtifact> configureAction) {
        DefaultDependencyArtifact artifact = new DefaultDependencyArtifact();
        configureAction.execute((Object)artifact);
        artifact.validate();
        this.artifacts.add(artifact);
        return artifact;
    }

    protected void copyTo(AbstractModuleDependency target) {
        super.copyTo(target);
        target.setArtifacts(new HashSet<DependencyArtifact>(this.getArtifacts()));
        target.setExcludeRuleContainer(new DefaultExcludeRuleContainer(this.getExcludeRules()));
        target.setTransitive(this.isTransitive());
        target.setAttributes(this.attributes);
    }

    protected boolean isKeyEquals(ModuleDependency dependencyRhs) {
        if (this.getGroup() != null ? !this.getGroup().equals(dependencyRhs.getGroup()) : dependencyRhs.getGroup() != null) {
            return false;
        }
        if (!this.getName().equals(dependencyRhs.getName())) {
            return false;
        }
        if (this.getTargetConfiguration() != null ? !this.getTargetConfiguration().equals(dependencyRhs.getTargetConfiguration()) : dependencyRhs.getTargetConfiguration() != null) {
            return false;
        }
        return !(this.getVersion() != null ? !this.getVersion().equals(dependencyRhs.getVersion()) : dependencyRhs.getVersion() != null);
    }

    protected boolean isCommonContentEquals(ModuleDependency dependencyRhs) {
        if (!this.isKeyEquals(dependencyRhs)) {
            return false;
        }
        if (this.isTransitive() != dependencyRhs.isTransitive()) {
            return false;
        }
        if (!Objects.equal(this.getArtifacts(), (Object)dependencyRhs.getArtifacts())) {
            return false;
        }
        if (!Objects.equal(this.getExcludeRules(), (Object)dependencyRhs.getExcludeRules())) {
            return false;
        }
        return Objects.equal((Object)this.getAttributes(), (Object)dependencyRhs.getAttributes());
    }

    public AttributeContainer getAttributes() {
        return this.attributes == null ? ImmutableAttributes.EMPTY : this.attributes.asImmutable();
    }

    public AbstractModuleDependency attributes(Action<? super AttributeContainer> configureAction) {
        this.validateMutation();
        if (this.attributesFactory == null) {
            this.warnAboutInternalApiUse();
            return this;
        }
        if (this.attributes == null) {
            this.attributes = this.attributesFactory.mutable();
        }
        configureAction.execute((Object)this.attributes);
        return this;
    }

    private void warnAboutInternalApiUse() {
        LOG.warn("Cannot set attributes for dependency \"" + this.getGroup() + ":" + this.getName() + ":" + this.getVersion() + "\": it was probably created by a plugin using internal APIs");
    }

    public void setAttributesFactory(ImmutableAttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    protected ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    void setAttributes(AttributeContainerInternal attributes) {
        this.attributes = attributes;
    }

    public void addMutationValidator(Action<? super ModuleDependency> action) {
        this.onMutate = ImmutableActionSet.of((Action[])new Action[]{this.onMutate, action});
    }

    protected void validateMutation() {
        this.onMutate.execute((Object)this);
    }

    protected void validateMutation(Object currentValue, Object newValue) {
        if (!Objects.equal((Object)currentValue, (Object)newValue)) {
            this.validateMutation();
        }
    }
}

