/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.util.CollectionUtils;

public class DefaultIncludeDirectives
implements IncludeDirectives {
    private final ImmutableList<Include> allIncludes;
    private final ImmutableListMultimap<String, Macro> macros;
    private final ImmutableListMultimap<String, MacroFunction> macroFunctions;

    public DefaultIncludeDirectives(ImmutableList<Include> allIncludes, ImmutableList<Macro> macros, ImmutableList<MacroFunction> macroFunctions) {
        this(allIncludes, (ImmutableListMultimap<String, Macro>)Multimaps.index(macros, (Function)new Function<Macro, String>(){

            @Nullable
            public String apply(@Nullable Macro input) {
                return input.getName();
            }
        }), (ImmutableListMultimap<String, MacroFunction>)Multimaps.index(macroFunctions, (Function)new Function<MacroFunction, String>(){

            @Nullable
            public String apply(@Nullable MacroFunction input) {
                return input.getName();
            }
        }));
    }

    private DefaultIncludeDirectives(ImmutableList<Include> allIncludes, ImmutableListMultimap<String, Macro> macros, ImmutableListMultimap<String, MacroFunction> macroFunctions) {
        this.allIncludes = allIncludes;
        this.macros = macros;
        this.macroFunctions = macroFunctions;
    }

    public List<Include> getQuotedIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.QUOTED;
            }
        });
    }

    public List<Include> getSystemIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.SYSTEM;
            }
        });
    }

    public List<Include> getMacroIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.MACRO;
            }
        });
    }

    public List<Include> getAll() {
        return this.allIncludes;
    }

    public List<Include> getIncludesOnly() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return !element.isImport();
            }
        });
    }

    public Iterable<Macro> getMacros(String name) {
        return this.macros.get((Object)name);
    }

    public Collection<Macro> getAllMacros() {
        return this.macros.values();
    }

    public Iterable<MacroFunction> getMacroFunctions(String name) {
        return this.macroFunctions.get((Object)name);
    }

    public Collection<MacroFunction> getAllMacroFunctions() {
        return this.macroFunctions.values();
    }

    public boolean hasMacros() {
        return !this.macros.isEmpty();
    }

    public boolean hasMacroFunctions() {
        return !this.macroFunctions.isEmpty();
    }

    public IncludeDirectives discardImports() {
        return new DefaultIncludeDirectives((ImmutableList<Include>)ImmutableList.copyOf(this.getIncludesOnly()), this.macros, this.macroFunctions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIncludeDirectives that = (DefaultIncludeDirectives)o;
        return this.allIncludes.equals(that.allIncludes) && this.macros.equals(that.macros) && this.macroFunctions.equals(that.macroFunctions);
    }

    public int hashCode() {
        return this.allIncludes.hashCode() ^ this.macros.hashCode() ^ this.macroFunctions.hashCode();
    }
}

