/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;
import org.gradle.swiftpm.internal.SwiftPmTarget;

@Incubating
@NonNullApi
public class CppBasePlugin
implements Plugin<ProjectInternal> {
    private final ProjectPublicationRegistry publicationRegistry;

    @Inject
    public CppBasePlugin(ProjectPublicationRegistry publicationRegistry) {
        this.publicationRegistry = publicationRegistry;
    }

    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        ((FeaturePreviews)project.getGradle().getServices().get(FeaturePreviews.class)).enableFeature(FeaturePreviews.Feature.GRADLE_METADATA);
        project.getComponents().withType(DefaultCppBinary.class, (Action)new Action<DefaultCppBinary>(){

            public void execute(final DefaultCppBinary binary) {
                Names names = binary.getNames();
                String language = "cpp";
                CppPlatform currentPlatform = binary.getTargetPlatform();
                NativeToolChainInternal toolChain = binary.getToolChain();
                Callable<List<File>> systemIncludes = new Callable<List<File>>(){

                    @Override
                    public List<File> call() {
                        PlatformToolProvider platformToolProvider = binary.getPlatformToolProvider();
                        return platformToolProvider.getSystemLibraries(ToolType.CPP_COMPILER).getIncludeDirs();
                    }
                };
                CppCompile compile = (CppCompile)tasks.create(names.getCompileTaskName(language), CppCompile.class);
                compile.includes(binary.getCompileIncludePath());
                compile.includes(systemIncludes);
                compile.source(binary.getCppSource());
                if (binary.isDebuggable()) {
                    compile.setDebuggable(true);
                }
                if (binary.isOptimized()) {
                    compile.setOptimized(true);
                }
                compile.getTargetPlatform().set((Object)currentPlatform);
                compile.getToolChain().set((Object)toolChain);
                compile.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                binary.getObjectsDir().set((Provider)compile.getObjectFileDir());
                binary.getCompileTask().set((Object)compile);
            }
        });
        project.getComponents().withType(CppSharedLibrary.class, (Action)new Action<CppSharedLibrary>(){

            public void execute(CppSharedLibrary library) {
                ((CppCompile)((Object)library.getCompileTask().get())).setPositionIndependentCode(true);
            }
        });
        project.getComponents().withType(ProductionCppComponent.class, (Action)new Action<ProductionCppComponent>(){

            public void execute(final ProductionCppComponent component) {
                project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        DefaultCppComponent componentInternal = (DefaultCppComponent)((Object)component);
                        CppBasePlugin.this.publicationRegistry.registerPublication(project.getPath(), (ProjectPublication)new DefaultProjectPublication(componentInternal.getDisplayName(), (Object)new SwiftPmTarget((String)component.getBaseName().get()), false));
                    }
                });
            }
        });
    }
}

