/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;

abstract class IncrementalFiler
implements Filer {
    protected final Filer delegate;
    protected final AnnotationProcessingResult result;
    protected final Messager messager;

    IncrementalFiler(Filer delegate, AnnotationProcessingResult result, Messager messager) {
        this.delegate = delegate;
        this.result = result;
        this.messager = messager;
    }

    @Override
    public final JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        this.recordGeneratedType(name, originatingElements);
        return this.delegate.createSourceFile(name, originatingElements);
    }

    @Override
    public final JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        this.recordGeneratedType(name, originatingElements);
        return this.delegate.createClassFile(name, originatingElements);
    }

    protected abstract void recordGeneratedType(CharSequence var1, Element[] var2);

    @Override
    public final FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "Incremental annotation processors are not allowed to create resources.");
        return this.delegate.createResource(location, pkg, relativeName, originatingElements);
    }

    @Override
    public final FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "Incremental annotation processors are not allowed to read resources.");
        return this.delegate.getResource(location, pkg, relativeName);
    }
}

