/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import javax.annotation.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.CategorisedOutputEvent;
import org.gradle.internal.logging.events.operations.ProgressStartBuildOperationProgressDetails;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.OperationIdentifier;

public class ProgressStartEvent
extends CategorisedOutputEvent
implements ProgressStartBuildOperationProgressDetails {
    private final OperationIdentifier progressOperationId;
    private final OperationIdentifier parentProgressOperationId;
    private final String description;
    private final String shortDescription;
    private final String loggingHeader;
    private final String status;
    private final int totalProgress;
    private final boolean buildOperationStart;
    private final OperationIdentifier buildOperationId;
    private final OperationIdentifier parentBuildOperationId;
    private final BuildOperationCategory buildOperationCategory;

    public ProgressStartEvent(OperationIdentifier progressOperationId, @Nullable OperationIdentifier parentProgressOperationId, long timestamp, String category, String description, @Nullable String shortDescription, @Nullable String loggingHeader, String status, int totalProgress, boolean buildOperationStart, @Nullable OperationIdentifier buildOperationId, @Nullable OperationIdentifier parentBuildOperationId, @Nullable BuildOperationCategory buildOperationCategory) {
        super(timestamp, category, LogLevel.LIFECYCLE);
        this.progressOperationId = progressOperationId;
        this.parentProgressOperationId = parentProgressOperationId;
        this.description = description;
        this.shortDescription = shortDescription;
        this.loggingHeader = loggingHeader;
        this.status = status;
        this.totalProgress = totalProgress;
        this.buildOperationStart = buildOperationStart;
        this.buildOperationId = buildOperationId;
        this.parentBuildOperationId = parentBuildOperationId;
        this.buildOperationCategory = buildOperationCategory == null ? BuildOperationCategory.UNCATEGORIZED : buildOperationCategory;
    }

    @Nullable
    public OperationIdentifier getParentProgressOperationId() {
        return this.parentProgressOperationId;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Nullable
    public String getLoggingHeader() {
        return this.loggingHeader;
    }

    public String getStatus() {
        return this.status;
    }

    public int getTotalProgress() {
        return this.totalProgress;
    }

    public String toString() {
        return "ProgressStart " + this.description;
    }

    public OperationIdentifier getProgressOperationId() {
        return this.progressOperationId;
    }

    public boolean isBuildOperationStart() {
        return this.buildOperationStart;
    }

    @Nullable
    public OperationIdentifier getBuildOperationId() {
        return this.buildOperationId;
    }

    @Nullable
    public OperationIdentifier getParentBuildOperationId() {
        return this.parentBuildOperationId;
    }

    public BuildOperationCategory getBuildOperationCategory() {
        return this.buildOperationCategory;
    }
}

