/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.XmlProvider;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.Finalize;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class IvyPluginPublishingRules
extends RuleSource {
    IvyPluginPublishingRules() {
    }

    @Mutate
    public void addMainPublication(PublishingExtension publishing, GradlePluginDevelopmentExtension pluginDevelopment, ServiceRegistry services) {
        if (!pluginDevelopment.isAutomatedPublishing()) {
            return;
        }
        SoftwareComponentContainer componentContainer = (SoftwareComponentContainer)services.get(SoftwareComponentContainer.class);
        SoftwareComponent component = (SoftwareComponent)componentContainer.getByName("java");
        PublicationContainer publications = publishing.getPublications();
        this.createIvyPluginPublication(component, publications);
    }

    @Finalize
    public void addMarkerPublications(PublishingExtension publishing, GradlePluginDevelopmentExtension pluginDevelopment) {
        if (!pluginDevelopment.isAutomatedPublishing()) {
            return;
        }
        PublicationContainer publications = publishing.getPublications();
        NamedDomainObjectContainer<PluginDeclaration> declaredPlugins = pluginDevelopment.getPlugins();
        for (PluginDeclaration declaration : declaredPlugins) {
            this.createIvyMarkerPublication(declaration, (IvyPublication)publications.getByName("pluginIvy"), publications);
        }
    }

    private void createIvyPluginPublication(SoftwareComponent component, PublicationContainer publications) {
        IvyPublication publication = (IvyPublication)publications.maybeCreate("pluginIvy", IvyPublication.class);
        publication.from(component);
    }

    private void createIvyMarkerPublication(PluginDeclaration declaration, final IvyPublication mainPublication, PublicationContainer publications) {
        String pluginId = declaration.getId();
        IvyPublicationInternal publication = (IvyPublicationInternal)publications.create(declaration.getName() + "PluginMarkerIvy", IvyPublication.class);
        publication.setAlias(true);
        publication.setOrganisation(pluginId);
        publication.setModule(pluginId + ".gradle.plugin");
        publication.descriptor((Action)new Action<IvyModuleDescriptorSpec>(){

            public void execute(IvyModuleDescriptorSpec descriptor) {
                descriptor.withXml((Action)new Action<XmlProvider>(){

                    public void execute(XmlProvider xmlProvider) {
                        Element root = xmlProvider.asElement();
                        Document document = root.getOwnerDocument();
                        Node dependencies = root.getElementsByTagName("dependencies").item(0);
                        Node dependency = dependencies.appendChild(document.createElement("dependency"));
                        Attr org = document.createAttribute("org");
                        org.setValue(mainPublication.getOrganisation());
                        dependency.getAttributes().setNamedItem(org);
                        Attr name = document.createAttribute("name");
                        name.setValue(mainPublication.getModule());
                        dependency.getAttributes().setNamedItem(name);
                        Attr rev = document.createAttribute("rev");
                        rev.setValue(mainPublication.getRevision());
                        dependency.getAttributes().setNamedItem(rev);
                    }
                });
            }
        });
    }
}

