/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.intermediate;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorWithScope;
import org.jetbrains.kotlin.psi2ir.intermediate.CallReceiver;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.psi2ir.intermediate.VariableLValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0016\u001a\u00020\u00172\u001c\u0010\u0018\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/psi2ir/intermediate/SafeCallReceiver;", "Lorg/jetbrains/kotlin/psi2ir/intermediate/CallReceiver;", "generator", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;", "startOffset", "", "endOffset", "extensionReceiver", "Lorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;", "dispatchReceiver", "isAssignmentReceiver", "", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;IILorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;Lorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;Z)V", "getDispatchReceiver", "()Lorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;", "getEndOffset", "()I", "getExtensionReceiver", "getGenerator", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;", "()Z", "getStartOffset", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "withDispatchAndExtensionReceivers", "Lkotlin/Function2;", "ir.psi2ir"})
public final class SafeCallReceiver
implements CallReceiver {
    @NotNull
    private final GeneratorWithScope generator;
    private final int startOffset;
    private final int endOffset;
    @Nullable
    private final IntermediateValue extensionReceiver;
    @Nullable
    private final IntermediateValue dispatchReceiver;
    private final boolean isAssignmentReceiver;

    @Override
    @NotNull
    public IrExpression call(@NotNull Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression> withDispatchAndExtensionReceivers) {
        KotlinType kotlinType;
        IntermediateValue extensionReceiverValue;
        IntermediateValue dispatchReceiverValue;
        Intrinsics.checkParameterIsNotNull(withDispatchAndExtensionReceivers, (String)"withDispatchAndExtensionReceivers");
        Scope scope = this.generator.getScope();
        Object object = this.extensionReceiver;
        if (object == null || (object = object.load()) == null) {
            IntermediateValue intermediateValue = this.dispatchReceiver;
            if (intermediateValue == null) {
                Intrinsics.throwNpe();
            }
            object = intermediateValue.load();
        }
        IrVariable irTmp = Scope.createTemporaryVariable$default(scope, (IrExpression)object, "safe_receiver", false, null, 12, null);
        VariableLValue safeReceiverValue = new VariableLValue(irTmp, null, 2, null);
        if (this.extensionReceiver != null) {
            dispatchReceiverValue = this.dispatchReceiver;
            extensionReceiverValue = safeReceiverValue;
        } else {
            dispatchReceiverValue = safeReceiverValue;
            extensionReceiverValue = null;
        }
        IrExpression irResult = (IrExpression)withDispatchAndExtensionReceivers.invoke((Object)dispatchReceiverValue, (Object)extensionReceiverValue);
        if (this.isAssignmentReceiver) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(irResult.getType()).getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"irResult.type.builtIns.unitType");
            kotlinType = simpleType2;
        } else {
            kotlinType = TypeUtilsKt.makeNullable(irResult.getType());
        }
        KotlinType resultType = kotlinType;
        IrBlockImpl irBlock2 = new IrBlockImpl(this.startOffset, this.endOffset, resultType, IrStatementOrigin.SAFE_CALL.INSTANCE);
        irBlock2.getStatements().add(irTmp);
        IrIfThenElseImpl irIfThenElse = new IrIfThenElseImpl(this.startOffset, this.endOffset, resultType, PrimitivesKt.equalsNull(this.generator.getContext(), this.startOffset, this.endOffset, safeReceiverValue.load()), PrimitivesKt.constNull(this.generator.getContext(), this.startOffset, this.endOffset), irResult, IrStatementOrigin.SAFE_CALL.INSTANCE);
        irBlock2.getStatements().add(irIfThenElse);
        return irBlock2;
    }

    @NotNull
    public final GeneratorWithScope getGenerator() {
        return this.generator;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    @Nullable
    public final IntermediateValue getExtensionReceiver() {
        return this.extensionReceiver;
    }

    @Nullable
    public final IntermediateValue getDispatchReceiver() {
        return this.dispatchReceiver;
    }

    public final boolean isAssignmentReceiver() {
        return this.isAssignmentReceiver;
    }

    public SafeCallReceiver(@NotNull GeneratorWithScope generator, int startOffset, int endOffset, @Nullable IntermediateValue extensionReceiver, @Nullable IntermediateValue dispatchReceiver, boolean isAssignmentReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        this.generator = generator;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.extensionReceiver = extensionReceiver;
        this.dispatchReceiver = dispatchReceiver;
        this.isAssignmentReceiver = isAssignmentReceiver;
    }
}

