/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.wrapper.Wrapper;

public enum BuildInitDsl {
    GROOVY(".gradle", Wrapper.DistributionType.BIN),
    KOTLIN(".gradle.kts", Wrapper.DistributionType.ALL);

    private final String fileExtension;
    private final Wrapper.DistributionType wrapperDistributionType;

    private BuildInitDsl(String fileExtension, Wrapper.DistributionType wrapperDistributionType) {
        this.fileExtension = fileExtension;
        this.wrapperDistributionType = wrapperDistributionType;
    }

    public static BuildInitDsl fromName(@Nullable String name) {
        if (name == null) {
            return GROOVY;
        }
        for (BuildInitDsl language : BuildInitDsl.values()) {
            if (!language.getId().equals(name)) continue;
            return language;
        }
        throw new GradleException("The requested build script DSL '" + name + "' is not supported.");
    }

    public static List<String> listSupported() {
        ImmutableList.Builder supported = ImmutableList.builder();
        for (BuildInitDsl dsl : BuildInitDsl.values()) {
            supported.add((Object)dsl.getId());
        }
        return supported.build();
    }

    public String getId() {
        return this.name().toLowerCase();
    }

    public Wrapper.DistributionType getWrapperDistributionType() {
        return this.wrapperDistributionType;
    }

    public String fileNameFor(String fileNameWithoutExtension) {
        return fileNameWithoutExtension + this.fileExtension;
    }

    public String toString() {
        return this.getId();
    }
}

