/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.IncompatibleConfigurationSelectionException;
import org.gradle.internal.component.model.AbstractDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.exceptions.ConfigurationNotConsumableException;
import org.gradle.util.GUtil;

public class LocalComponentDependencyMetadata
extends AbstractDependencyMetadata
implements LocalOriginDependencyMetadata {
    private final ComponentSelector selector;
    private final String moduleConfiguration;
    private final String dependencyConfiguration;
    private final List<Exclude> excludes;
    private final Set<IvyArtifactName> artifactNames;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final AttributeContainer moduleAttributes;

    public LocalComponentDependencyMetadata(ComponentSelector selector, String moduleConfiguration, AttributeContainer moduleAttributes, String dependencyConfiguration, Set<IvyArtifactName> artifactNames, List<Exclude> excludes, boolean force, boolean changing, boolean transitive) {
        this.selector = selector;
        this.moduleConfiguration = moduleConfiguration;
        this.moduleAttributes = moduleAttributes;
        this.dependencyConfiguration = dependencyConfiguration;
        this.artifactNames = artifactNames;
        this.excludes = excludes;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
    }

    public String toString() {
        return "dependency: " + this.selector + " from-conf: " + this.moduleConfiguration + " to-conf: " + this.dependencyConfiguration;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public String getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    @Override
    public String getDependencyConfiguration() {
        return LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.dependencyConfiguration);
    }

    @Override
    public Set<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        AttributesSchemaInternal producerAttributeSchema;
        boolean useConfigurationAttributes;
        boolean consumerHasAttributes = !consumerAttributes.isEmpty();
        List<? extends ConfigurationMetadata> consumableConfigurations = targetComponent.getVariantsForGraphTraversal();
        boolean bl = useConfigurationAttributes = this.dependencyConfiguration == null && (consumerHasAttributes || !consumableConfigurations.isEmpty());
        if (useConfigurationAttributes) {
            return ImmutableSet.of((Object)this.selectConfigurationUsingAttributeMatching(consumerAttributes, targetComponent, consumerSchema));
        }
        String targetConfiguration = (String)GUtil.elvis((Object)this.dependencyConfiguration, (Object)"default");
        ConfigurationMetadata toConfiguration = targetComponent.getConfiguration(targetConfiguration);
        if (toConfiguration == null) {
            throw new ConfigurationNotFoundException(fromComponent.getComponentId(), this.moduleConfiguration, targetConfiguration, targetComponent.getComponentId());
        }
        if (!toConfiguration.isCanBeConsumed()) {
            throw new ConfigurationNotConsumableException(targetComponent.toString(), toConfiguration.getName());
        }
        if (consumerHasAttributes && !toConfiguration.getAttributes().isEmpty() && !consumerSchema.withProducer(producerAttributeSchema = targetComponent.getAttributesSchema()).isMatching((AttributeContainerInternal)toConfiguration.getAttributes(), (AttributeContainerInternal)consumerAttributes)) {
            throw new IncompatibleConfigurationSelectionException((AttributeContainerInternal)consumerAttributes, consumerSchema.withProducer(producerAttributeSchema), targetComponent, targetConfiguration);
        }
        return ImmutableSet.of((Object)toConfiguration);
    }

    private static String getOrDefaultConfiguration(String configuration) {
        return (String)GUtil.elvis((Object)configuration, (Object)"default");
    }

    @Override
    public Set<String> getModuleConfigurations() {
        return ImmutableSet.of((Object)LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.moduleConfiguration));
    }

    @Override
    public List<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<Exclude> getExcludes(Collection<String> configurations) {
        return this.excludes;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata fromConfiguration, ConfigurationMetadata toConfiguration) {
        if (this.artifactNames.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ComponentArtifactMetadata> artifacts = new LinkedHashSet<ComponentArtifactMetadata>();
        for (IvyArtifactName artifactName : this.artifactNames) {
            artifacts.add(toConfiguration.artifact(artifactName));
        }
        return artifacts;
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.artifactNames;
    }

    @Override
    public LocalOriginDependencyMetadata withTarget(ComponentSelector target) {
        if (this.selector.equals(target)) {
            return this;
        }
        return this.copyWithTarget(target);
    }

    private LocalOriginDependencyMetadata copyWithTarget(ComponentSelector selector) {
        return new LocalComponentDependencyMetadata(selector, this.moduleConfiguration, this.moduleAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive);
    }
}

