/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.resolve.ModuleVersionResolveException;

class EdgeState
implements DependencyGraphEdge {
    private final DependencyMetadata dependencyMetadata;
    private final NodeState from;
    private final SelectorState selector;
    private final ResolveState resolveState;
    private final ModuleExclusion moduleExclusion;
    private final Set<NodeState> targetNodes = new LinkedHashSet<NodeState>();
    private ComponentState targetModuleRevision;
    private ModuleVersionResolveException targetNodeSelectionFailure;

    EdgeState(NodeState from, DependencyState dependencyState, ModuleExclusion moduleExclusion, ResolveState resolveState) {
        this.from = from;
        this.dependencyMetadata = dependencyState.getDependencyMetadata();
        this.moduleExclusion = moduleExclusion;
        this.resolveState = resolveState;
        this.selector = resolveState.getSelector(this.dependencyMetadata, dependencyState.getModuleIdentifier());
    }

    public String toString() {
        return String.format("%s -> %s", this.from.toString(), this.dependencyMetadata);
    }

    @Override
    public NodeState getFrom() {
        return this.from;
    }

    DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    ComponentState getTargetComponent() {
        return this.targetModuleRevision;
    }

    @Override
    public DependencyGraphSelector getSelector() {
        return this.selector;
    }

    public ComponentState resolveModuleRevisionId() {
        if (this.targetModuleRevision == null) {
            this.targetModuleRevision = this.selector.resolveModuleRevisionId();
            this.selector.getSelectedModule().addUnattachedDependency(this);
        }
        return this.targetModuleRevision;
    }

    public boolean isTransitive() {
        return this.from.isTransitive() && this.dependencyMetadata.isTransitive();
    }

    public void attachToTargetConfigurations() {
        if (!this.targetModuleRevision.isSelected()) {
            return;
        }
        this.calculateTargetConfigurations();
        for (NodeState targetConfiguration : this.targetNodes) {
            targetConfiguration.addIncomingEdge(this);
        }
        if (!this.targetNodes.isEmpty()) {
            this.selector.getSelectedModule().removeUnattachedDependency(this);
        }
    }

    public void removeFromTargetConfigurations() {
        for (NodeState targetConfiguration : this.targetNodes) {
            targetConfiguration.removeIncomingEdge(this);
        }
        this.targetNodes.clear();
        this.targetNodeSelectionFailure = null;
        if (this.targetModuleRevision != null) {
            this.selector.getSelectedModule().removeUnattachedDependency(this);
        }
    }

    public void restart(ComponentState selected) {
        this.removeFromTargetConfigurations();
        this.targetModuleRevision = selected;
        this.attachToTargetConfigurations();
    }

    private void calculateTargetConfigurations() {
        Set<ConfigurationMetadata> targetConfigurations;
        this.targetNodes.clear();
        this.targetNodeSelectionFailure = null;
        ComponentResolveMetadata targetModuleVersion = this.targetModuleRevision.getMetaData();
        if (targetModuleVersion == null) {
            return;
        }
        ImmutableAttributes attributes = this.resolveState.getRoot().getMetadata().getAttributes();
        try {
            targetConfigurations = this.dependencyMetadata.selectConfigurations(attributes, this.from.getComponent().getMetadata(), this.from.getMetadata(), targetModuleVersion, this.resolveState.getAttributesSchema());
        }
        catch (Throwable t) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyMetadata.getSelector(), t);
            return;
        }
        for (ConfigurationMetadata targetConfiguration : targetConfigurations) {
            NodeState targetNodeState = this.resolveState.getNode(this.targetModuleRevision, targetConfiguration);
            this.targetNodes.add(targetNodeState);
        }
    }

    public ModuleExclusion toExclusions(DependencyMetadata md, ConfigurationMetadata from) {
        List<Exclude> excludes = md.getExcludes(from.getHierarchy());
        if (excludes.isEmpty()) {
            return ModuleExclusions.excludeNone();
        }
        return this.resolveState.getModuleExclusions().excludeAny((ImmutableList<Exclude>)ImmutableList.copyOf(excludes));
    }

    @Override
    public ModuleExclusion getExclusions(ModuleExclusions moduleExclusions) {
        ModuleExclusion edgeExclusions = this.toExclusions(this.dependencyMetadata, this.from.getMetadata());
        return this.resolveState.getModuleExclusions().intersect(edgeExclusions, this.moduleExclusion);
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependencyMetadata.getSelector();
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        if (this.targetNodeSelectionFailure != null) {
            return this.targetNodeSelectionFailure;
        }
        return this.selector.getFailure();
    }

    @Override
    public Long getSelected() {
        return this.selector.getSelected().getResultId();
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.selector.getSelectionReason();
    }

    @Override
    public ModuleDependency getModuleDependency() {
        if (this.dependencyMetadata instanceof DslOriginDependencyMetadata) {
            return ((DslOriginDependencyMetadata)this.dependencyMetadata).getSource();
        }
        return null;
    }

    @Override
    public Iterable<? extends DependencyGraphNode> getTargets() {
        return this.targetNodes;
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata metaData1) {
        return this.dependencyMetadata.getArtifacts(this.from.getMetadata(), metaData1);
    }
}

