/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;

public class DependencySubstitutionResolver
implements DependencyToComponentIdResolver {
    private final DependencyToComponentIdResolver resolver;
    private final DependencySubstitutionApplicator applicator;

    public DependencySubstitutionResolver(DependencyToComponentIdResolver resolver, DependencySubstitutionApplicator applicator) {
        this.resolver = resolver;
        this.applicator = applicator;
    }

    @Override
    public void resolve(DependencyMetadata dependency, BuildableComponentIdResolveResult result) {
        DependencySubstitutionApplicator.SubstitutionResult application = this.applicator.apply(dependency);
        if (application.hasFailure()) {
            result.failed(new ModuleVersionResolveException(dependency.getSelector(), application.getFailure()));
            return;
        }
        DependencySubstitutionInternal details = application.getResult();
        if (details.isUpdated()) {
            DependencyMetadata target = dependency.withTarget(details.getTarget());
            this.resolver.resolve(target, result);
            result.setSelectionReason(details.getSelectionReason());
            return;
        }
        this.resolver.resolve(dependency, result);
    }
}

