/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reflect;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.internal.Cast;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class TypeOf<T> {
    private final ModelType<T> type;

    public static <T> TypeOf<T> typeOf(Class<T> type) {
        return new TypeOf<T>((ModelType)ModelType.of(TypeOf.typeWhichCannotBeNull(type))){};
    }

    public static <T> TypeOf<T> typeOf(Type type) {
        return new TypeOf<T>((ModelType)Cast.uncheckedCast(ModelType.of(TypeOf.typeWhichCannotBeNull(type)))){};
    }

    public static TypeOf<?> parameterizedTypeOf(TypeOf<?> parameterizedType, TypeOf<?> ... typeArguments) {
        ModelType parameterizedModelType = parameterizedType.type;
        if (!parameterizedModelType.isParameterized()) {
            throw new IllegalArgumentException("Expecting a parameterized type, got: " + parameterizedType + ".");
        }
        return TypeOf.typeOf(parameterizedModelType.withArguments(TypeOf.modelTypeListFrom(typeArguments)));
    }

    private TypeOf(ModelType<T> type) {
        this.type = type;
    }

    protected TypeOf() {
        this.type = this.captureTypeArgument();
    }

    public boolean isSimple() {
        return this.type.isClass() && !this.rawClass().isArray();
    }

    public boolean isSynthetic() {
        return this.rawClass().isSynthetic();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    private int getModifiers() {
        return this.rawClass().getModifiers();
    }

    public boolean isArray() {
        return this.type.isGenericArray() || this.type.isClass() && this.rawClass().isArray();
    }

    @Nullable
    public TypeOf<?> getComponentType() {
        return this.type.isGenericArray() ? TypeOf.typeOf(this.type.getComponentType()) : this.nullableTypeOf(this.rawClass().getComponentType());
    }

    public boolean isParameterized() {
        return this.type.isParameterized();
    }

    public TypeOf<?> getParameterizedTypeDefinition() {
        return TypeOf.typeOf(this.type.getRawType());
    }

    public List<TypeOf<?>> getActualTypeArguments() {
        return TypeOf.typeOfListFrom(this.type.getTypeVariables());
    }

    public boolean isWildcard() {
        return this.type.isWildcard();
    }

    @Nullable
    public TypeOf<?> getUpperBound() {
        return this.nullableTypeOf(this.type.getUpperBound());
    }

    public final boolean isAssignableFrom(TypeOf<?> type) {
        return this.type.isAssignableFrom(type.type);
    }

    public final boolean isAssignableFrom(Type type) {
        return this.type.isAssignableFrom(ModelType.of(type));
    }

    public String getSimpleName() {
        return this.type.getDisplayName();
    }

    public final String toString() {
        return this.type.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeOf)) {
            return false;
        }
        TypeOf typeOf = (TypeOf)o;
        return this.type.equals(typeOf.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    private ModelType<T> captureTypeArgument() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        Class<Object> type = genericSuperclass instanceof ParameterizedType ? ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0] : Object.class;
        return (ModelType)Cast.uncheckedCast(ModelType.of(type));
    }

    private Class<? super T> rawClass() {
        return this.type.getRawClass();
    }

    private static <T> T typeWhichCannotBeNull(T type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        return type;
    }

    private static List<ModelType<?>> modelTypeListFrom(TypeOf<?>[] typeOfs) {
        return TypeOf.map(Arrays.asList(typeOfs), new Function<TypeOf<?>, ModelType<?>>(){

            public ModelType<?> apply(TypeOf<?> it) {
                return ((TypeOf)it).type;
            }
        });
    }

    private static List<TypeOf<?>> typeOfListFrom(List<ModelType<?>> modelTypes) {
        return TypeOf.map(modelTypes, new Function<ModelType<?>, TypeOf<?>>(){

            public TypeOf<?> apply(ModelType<?> it) {
                return TypeOf.typeOf(it);
            }
        });
    }

    private static <U> TypeOf<U> typeOf(ModelType<U> componentType) {
        return new TypeOf<U>((ModelType)componentType){};
    }

    private TypeOf<?> nullableTypeOf(Class<?> type) {
        return type != null ? TypeOf.typeOf(type) : null;
    }

    private TypeOf<?> nullableTypeOf(ModelType<?> type) {
        return type != null ? TypeOf.typeOf(type) : null;
    }

    private static <T, U> List<U> map(Iterable<T> iterable, Function<T, U> function) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(iterable, function));
    }
}

