/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import groovy.util.Node;
import java.util.HashMap;
import java.util.Map;
import org.gradle.plugins.ide.idea.model.Dependency;

public class ModuleDependency
implements Dependency {
    private String name;
    private String scope;
    private boolean exported;

    public ModuleDependency(String name, String scope) {
        this.name = name;
        this.scope = scope;
        this.exported = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isExported() {
        return this.exported;
    }

    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    public void addToNode(Node parentNode) {
        HashMap attributes = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)"type", (Object)"module").put((Object)"module-name", (Object)this.name).putAll(this.getAttributeMapForScopeAndExported()).build());
        parentNode.appendNode((Object)"orderEntry", (Map)attributes);
    }

    private Map<String, Object> getAttributeMapForScopeAndExported() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.exported) {
            builder.put((Object)"exported", (Object)"");
        }
        if (!Strings.isNullOrEmpty((String)this.scope) && !"COMPILE".equals(this.scope)) {
            builder.put((Object)"scope", (Object)this.scope);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return Objects.equal((Object)this.name, (Object)that.name) && this.scopeEquals(this.scope, that.scope);
    }

    private boolean scopeEquals(String lhs, String rhs) {
        if ("COMPILE".equals(lhs)) {
            return Strings.isNullOrEmpty((String)rhs) || "COMPILE".equals(rhs);
        }
        if ("COMPILE".equals(rhs)) {
            return Strings.isNullOrEmpty((String)lhs) || "COMPILE".equals(lhs);
        }
        return Objects.equal((Object)lhs, (Object)rhs);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.getScopeHash();
        return result;
    }

    private int getScopeHash() {
        return !Strings.isNullOrEmpty((String)this.scope) && !this.scope.equals("COMPILE") ? this.scope.hashCode() : 0;
    }

    public String toString() {
        return "ModuleDependency{name='" + this.name + "'" + ", scope='" + this.scope + "'" + "}";
    }
}

