/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.metadata;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadata;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerType;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadata;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadataProvider;
import org.gradle.process.internal.ExecActionFactory;

public class CompilerMetaDataProviderFactory {
    private final CachingCompilerMetaDataProvider<GccMetadata> gcc;
    private final CachingCompilerMetaDataProvider<GccMetadata> clang;
    private final CachingCompilerMetaDataProvider<SwiftcMetadata> swiftc;

    public CompilerMetaDataProviderFactory(ExecActionFactory execActionFactory) {
        this.gcc = new CachingCompilerMetaDataProvider(GccMetadataProvider.forGcc(execActionFactory));
        this.clang = new CachingCompilerMetaDataProvider(GccMetadataProvider.forClang(execActionFactory));
        this.swiftc = new CachingCompilerMetaDataProvider(new SwiftcMetadataProvider(execActionFactory));
    }

    public CompilerMetaDataProvider<GccMetadata> gcc() {
        return this.gcc;
    }

    public CompilerMetaDataProvider<GccMetadata> clang() {
        return this.clang;
    }

    public CompilerMetaDataProvider<SwiftcMetadata> swiftc() {
        return this.swiftc;
    }

    private static class Key {
        final File gccBinary;
        final List<String> args;

        private Key(File gccBinary, List<String> args) {
            this.gccBinary = gccBinary;
            this.args = args;
        }

        public boolean equals(Object obj) {
            Key other = (Key)obj;
            return other.gccBinary.equals(this.gccBinary) && other.args.equals(this.args);
        }

        public int hashCode() {
            return this.gccBinary.hashCode() ^ this.args.hashCode();
        }
    }

    private static class CachingCompilerMetaDataProvider<T extends CompilerMetadata>
    implements CompilerMetaDataProvider<T> {
        private final CompilerMetaDataProvider<T> delegate;
        private final Map<Key, T> resultMap = new HashMap<Key, T>();

        private CachingCompilerMetaDataProvider(CompilerMetaDataProvider<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T getCompilerMetaData(File binary, List<String> additionalArgs) {
            Key key = new Key(binary, additionalArgs);
            CompilerMetadata result = (CompilerMetadata)this.resultMap.get(key);
            if (result == null) {
                result = this.delegate.getCompilerMetaData(binary, additionalArgs);
                this.resultMap.put(key, result);
            }
            return (T)result;
        }

        @Override
        public CompilerType getCompilerType() {
            return this.delegate.getCompilerType();
        }
    }
}

