/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.util.Collections;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.buildsrc.BuildBuildSrcBuildOperationType;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSourceBuilder.class);
    public static final BuildBuildSrcBuildOperationType.Details BUILD_BUILDSRC_DETAILS = new BuildBuildSrcBuildOperationType.Details(){};
    public static final BuildBuildSrcBuildOperationType.Result BUILD_BUILDSRC_RESULT = new BuildBuildSrcBuildOperationType.Result(){};
    private final NestedBuildFactory nestedBuildFactory;
    private final ClassLoaderScope classLoaderScope;
    private final CacheRepository cacheRepository;
    private final BuildOperationExecutor buildOperationExecutor;
    private final CachedClasspathTransformer cachedClasspathTransformer;
    private final BuildSrcBuildListenerFactory buildSrcBuildListenerFactory;

    public BuildSourceBuilder(NestedBuildFactory nestedBuildFactory, ClassLoaderScope classLoaderScope, CacheRepository cacheRepository, BuildOperationExecutor buildOperationExecutor, CachedClasspathTransformer cachedClasspathTransformer, BuildSrcBuildListenerFactory buildSrcBuildListenerFactory) {
        this.nestedBuildFactory = nestedBuildFactory;
        this.classLoaderScope = classLoaderScope;
        this.cacheRepository = cacheRepository;
        this.buildOperationExecutor = buildOperationExecutor;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
        this.buildSrcBuildListenerFactory = buildSrcBuildListenerFactory;
    }

    public ClassLoaderScope buildAndCreateClassLoader(StartParameter startParameter) {
        ClassPath classpath = this.createBuildSourceClasspath(startParameter);
        return this.classLoaderScope.createChild(startParameter.getCurrentDir().getAbsolutePath()).export(this.cachedClasspathTransformer.transform(classpath)).lock();
    }

    ClassPath createBuildSourceClasspath(final StartParameter startParameter) {
        assert (startParameter.getCurrentDir() != null && startParameter.getBuildFile() == null);
        LOGGER.debug("Starting to build the build sources.");
        if (!startParameter.getCurrentDir().isDirectory()) {
            LOGGER.debug("Gradle source dir does not exist. We leave.");
            return ClassPath.EMPTY;
        }
        return (ClassPath)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ClassPath>(){

            public ClassPath call(BuildOperationContext context) {
                ClassPath classPath = BuildSourceBuilder.this.buildBuildSrc(startParameter);
                context.setResult((Object)BUILD_BUILDSRC_RESULT);
                return classPath;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build buildSrc").progressDisplayName("buildSrc").details((Object)BUILD_BUILDSRC_DETAILS);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath buildBuildSrc(StartParameter startParameter) {
        PersistentCache buildSrcCache = this.createCache(startParameter);
        try {
            ClassPath classPath;
            BuildController buildController = this.createBuildController(startParameter);
            try {
                classPath = (ClassPath)buildSrcCache.useCache((Factory)new BuildSrcUpdateFactory(buildSrcCache, buildController, this.buildSrcBuildListenerFactory));
            }
            catch (Throwable throwable) {
                buildController.stop();
                throw throwable;
            }
            buildController.stop();
            return classPath;
        }
        finally {
            buildSrcCache.close();
        }
    }

    PersistentCache createCache(StartParameter startParameter) {
        return this.cacheRepository.cache(new File(startParameter.getCurrentDir(), ".gradle/noVersion/buildSrc")).withCrossVersionCache(CacheBuilder.LockTarget.CachePropertiesFile).withDisplayName("buildSrc state cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None).useCrossVersionImplementation()).withProperties(Collections.singletonMap("gradle.version", GradleVersion.current().getVersion())).open();
    }

    private BuildController createBuildController(StartParameter startParameter) {
        GradleLauncher gradleLauncher = this.buildGradleLauncher(startParameter);
        return new GradleBuildController(gradleLauncher);
    }

    private GradleLauncher buildGradleLauncher(StartParameter startParameter) {
        StartParameter startParameterArg = startParameter.newInstance();
        startParameterArg.setProjectProperties(startParameter.getProjectProperties());
        startParameterArg.setSearchUpwards(false);
        startParameterArg.setProfile(startParameter.isProfile());
        GradleLauncher gradleLauncher = this.nestedBuildFactory.nestedInstance(startParameterArg);
        GradleInternal build = gradleLauncher.getGradle();
        if (build.getParent().findIdentityPath() == null) {
            Path path = build.getParent().getParent().getIdentityPath().child(startParameter.getCurrentDir().getParentFile().getName()).child(startParameter.getCurrentDir().getName());
            build.setIdentityPath(path);
        }
        return gradleLauncher;
    }
}

