/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.composite.internal.DefaultIncludedBuildController;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuilds;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;

class DefaultIncludedBuildControllers
implements Stoppable,
IncludedBuildControllers {
    private final Map<BuildIdentifier, IncludedBuildController> buildControllers = Maps.newHashMap();
    private final ManagedExecutor executorService;
    private final IncludedBuilds includedBuilds;
    private boolean taskExecutionStarted;

    DefaultIncludedBuildControllers(ExecutorFactory executorFactory, IncludedBuilds includedBuilds) {
        this.includedBuilds = includedBuilds;
        this.executorService = executorFactory.create("included builds");
    }

    public IncludedBuildController getBuildController(BuildIdentifier buildId) {
        IncludedBuildController buildController = this.buildControllers.get(buildId);
        if (buildController != null) {
            return buildController;
        }
        IncludedBuild build = this.includedBuilds.getBuild(buildId.getName());
        DefaultIncludedBuildController newBuildController = new DefaultIncludedBuildController(build);
        this.buildControllers.put(buildId, newBuildController);
        this.executorService.submit((Runnable)newBuildController);
        if (this.taskExecutionStarted) {
            newBuildController.startTaskExecution();
        }
        return newBuildController;
    }

    public void startTaskExecution() {
        this.taskExecutionStarted = true;
        this.populateTaskGraphs();
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            buildController.startTaskExecution();
        }
    }

    private void populateTaskGraphs() {
        boolean tasksDiscovered = true;
        while (tasksDiscovered) {
            tasksDiscovered = false;
            for (IncludedBuildController buildController : this.buildControllers.values()) {
                if (!buildController.populateTaskGraph()) continue;
                tasksDiscovered = true;
            }
        }
    }

    public void stopTaskExecution() {
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            buildController.stopTaskExecution();
        }
        this.buildControllers.clear();
        for (IncludedBuild includedBuild : this.includedBuilds.getBuilds()) {
            ((IncludedBuildInternal)includedBuild).finishBuild();
        }
    }

    public void stop() {
        CompositeStoppable.stoppable(this.buildControllers.values()).stop();
        this.executorService.stop();
    }
}

