/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.composite.internal.CompositeBuildDependencySubstitutions;
import org.gradle.composite.internal.IncludedBuildDependencyMetadataBuilder;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuilds;
import org.gradle.internal.Actions;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildableCompositeBuildContext
implements CompositeBuildContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildableCompositeBuildContext.class);
    private final IncludedBuilds includedBuilds;
    private final Set<File> configuredBuilds = Sets.newHashSet();
    private final Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> provided = Sets.newHashSet();
    private final Map<ProjectComponentIdentifier, RegisteredProject> projectMetadata = Maps.newHashMap();
    private final List<Action<DependencySubstitution>> substitutionRules = Lists.newArrayList();
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public DefaultBuildableCompositeBuildContext(IncludedBuilds includedBuilds, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.includedBuilds = includedBuilds;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public LocalComponentMetadata getComponent(ProjectComponentIdentifier project) {
        this.ensureRegistered(project);
        RegisteredProject registeredProject = this.projectMetadata.get(project);
        return registeredProject == null ? null : registeredProject.metaData;
    }

    public Collection<LocalComponentArtifactMetadata> getAdditionalArtifacts(ProjectComponentIdentifier project) {
        this.ensureRegistered(project);
        RegisteredProject registeredProject = this.projectMetadata.get(project);
        return registeredProject == null ? null : registeredProject.artifacts;
    }

    public void registerSubstitution(ModuleVersionIdentifier moduleId, ProjectComponentIdentifier project) {
        LOGGER.info("Registering " + project + " in composite build. Will substitute for module '" + moduleId.getModule() + "'.");
        this.provided.add((Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>)Pair.of((Object)moduleId, (Object)project));
    }

    public void registerSubstitution(Action<DependencySubstitution> substitutions) {
        this.substitutionRules.add(substitutions);
    }

    public void register(ProjectComponentIdentifier project, LocalComponentMetadata localComponentMetadata) {
        if (this.projectMetadata.containsKey(project)) {
            String failureMessage = StringUtils.capitalize((String)project.getDisplayName()) + " is not unique in composite.";
            throw new GradleException(failureMessage);
        }
        this.projectMetadata.put(project, new RegisteredProject(localComponentMetadata));
    }

    public void registerAdditionalArtifact(ProjectComponentIdentifier project, LocalComponentArtifactMetadata artifact) {
        this.getRegisteredProject((ProjectComponentIdentifier)project).artifacts.add(artifact);
    }

    private RegisteredProject getRegisteredProject(ProjectComponentIdentifier project) {
        this.ensureRegistered(project);
        RegisteredProject registeredProject = this.projectMetadata.get(project);
        if (registeredProject == null) {
            throw new IllegalStateException(String.format("Requested %s which was never registered", project));
        }
        return registeredProject;
    }

    public Action<DependencySubstitution> getRuleAction() {
        ArrayList allActions = Lists.newArrayList();
        if (!this.provided.isEmpty()) {
            allActions.add(new CompositeBuildDependencySubstitutions(this.provided, this.moduleIdentifierFactory));
        }
        allActions.addAll(this.substitutionRules);
        return Actions.composite((Iterable)allActions);
    }

    public boolean hasRules() {
        return !this.provided.isEmpty() || !this.substitutionRules.isEmpty();
    }

    private void ensureRegistered(ProjectComponentIdentifier projectComponentIdentifier) {
        if (this.projectMetadata.containsKey(projectComponentIdentifier)) {
            return;
        }
        IncludedBuildInternal build = this.getBuild(projectComponentIdentifier);
        if (build == null) {
            return;
        }
        this.ensureRegistered(build);
    }

    private IncludedBuildInternal getBuild(ProjectComponentIdentifier projectId) {
        return (IncludedBuildInternal)this.includedBuilds.getBuild(projectId.getBuild().getName());
    }

    private void ensureRegistered(IncludedBuildInternal build) {
        File buildDir = build.getProjectDir();
        if (this.configuredBuilds.contains(buildDir)) {
            return;
        }
        this.configureBuildToRegisterDependencyMetadata(build, this);
        this.configuredBuilds.add(buildDir);
    }

    private void configureBuildToRegisterDependencyMetadata(IncludedBuildInternal build, CompositeBuildContext context) {
        IncludedBuildDependencyMetadataBuilder contextBuilder = new IncludedBuildDependencyMetadataBuilder(context);
        contextBuilder.build(build);
    }

    private static class RegisteredProject {
        LocalComponentMetadata metaData;
        Collection<LocalComponentArtifactMetadata> artifacts = Lists.newArrayList();

        public RegisteredProject(LocalComponentMetadata metaData) {
            this.metaData = metaData;
        }
    }
}

