/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.internal.DefaultSwiftLibrary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.util.GUtil;

@Incubating
public class SwiftLibraryPlugin
implements Plugin<Project> {
    private final FileOperations fileOperations;

    @Inject
    public SwiftLibraryPlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        TaskContainer tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        ObjectFactory objectFactory = project.getObjects();
        SwiftLibrary library = (SwiftLibrary)project.getExtensions().create(SwiftLibrary.class, "library", DefaultSwiftLibrary.class, new Object[]{"main", objectFactory, this.fileOperations, configurations});
        project.getComponents().add((Object)library);
        project.getComponents().add((Object)library.getDebugSharedLibrary());
        project.getComponents().add((Object)library.getReleaseSharedLibrary());
        Property<String> module = library.getModule();
        module.set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        SwiftCompile compileDebug = (SwiftCompile)tasks.getByName("compileDebugSwift");
        final List currentCompilerArguments = (List)compileDebug.getCompilerArgs().getOrElse(Collections.emptyList());
        compileDebug.getCompilerArgs().set(project.provider((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return Lists.newArrayList((Iterable)Iterables.concat(Arrays.asList("-enable-testing"), (Iterable)currentCompilerArguments));
            }
        }));
        SwiftCompile compileRelease = (SwiftCompile)tasks.getByName("compileReleaseSwift");
        LinkSharedLibrary linkDebug = (LinkSharedLibrary)tasks.getByName("linkDebug");
        LinkSharedLibrary linkRelease = (LinkSharedLibrary)tasks.getByName("linkRelease");
        tasks.getByName("assemble").dependsOn(new Object[]{linkDebug});
        Configuration implementation = library.getImplementationDependencies();
        Configuration api = library.getApiDependencies();
        Configuration debugApiElements = (Configuration)configurations.maybeCreate("debugSwiftApiElements");
        debugApiElements.extendsFrom(new Configuration[]{api});
        debugApiElements.setCanBeResolved(false);
        debugApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
        debugApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugApiElements.getOutgoing().artifact((Object)compileDebug.getObjectFileDir());
        Configuration debugLinkElements = (Configuration)configurations.maybeCreate("debugLinkElements");
        debugLinkElements.extendsFrom(new Configuration[]{implementation});
        debugLinkElements.setCanBeResolved(false);
        debugLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-link"));
        debugLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugLinkElements.getOutgoing().artifact((Object)linkDebug.getBinaryFile());
        Configuration debugRuntimeElements = (Configuration)configurations.maybeCreate("debugRuntimeElements");
        debugRuntimeElements.extendsFrom(new Configuration[]{implementation});
        debugRuntimeElements.setCanBeResolved(false);
        debugRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-runtime"));
        debugRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugRuntimeElements.getOutgoing().artifact((Object)linkDebug.getBinaryFile());
        Configuration releaseApiElements = (Configuration)configurations.maybeCreate("releaseSwiftApiElements");
        releaseApiElements.extendsFrom(new Configuration[]{api});
        releaseApiElements.setCanBeResolved(false);
        releaseApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
        releaseApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseApiElements.getOutgoing().artifact((Object)compileRelease.getObjectFileDir());
        Configuration releaseLinkElements = (Configuration)configurations.maybeCreate("releaseLinkElements");
        releaseLinkElements.extendsFrom(new Configuration[]{implementation});
        releaseLinkElements.setCanBeResolved(false);
        releaseLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-link"));
        releaseLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseLinkElements.getOutgoing().artifact((Object)linkRelease.getBinaryFile());
        Configuration releaseRuntimeElements = (Configuration)configurations.maybeCreate("releaseRuntimeElements");
        releaseRuntimeElements.extendsFrom(new Configuration[]{implementation});
        releaseRuntimeElements.setCanBeResolved(false);
        releaseRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-runtime"));
        releaseRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseRuntimeElements.getOutgoing().artifact((Object)linkRelease.getBinaryFile());
    }
}

