/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.io.File;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftBundle;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.tasks.CreateSwiftBundle;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.plugins.SwiftCompilerPlugin;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.ToolChain;

@Incubating
public class SwiftBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(SwiftCompilerPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        final ModelRegistry modelRegistry = project.getModelRegistry();
        final ProviderFactory providers = project.getProviders();
        project.getComponents().withType(SwiftBinary.class, (Action)new Action<SwiftBinary>(){

            public void execute(final SwiftBinary binary) {
                final Names names = Names.of(binary.getName());
                SwiftCompile compile = (SwiftCompile)tasks.create(names.getCompileTaskName("swift"), SwiftCompile.class);
                compile.includes(binary.getCompileImportPath());
                compile.source(binary.getSwiftSource());
                if (binary.isDebuggable()) {
                    compile.setDebuggable(true);
                } else {
                    compile.setOptimized(true);
                }
                compile.setModuleName(binary.getModule());
                compile.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
                compile.setTargetPlatform((NativePlatform)currentPlatform);
                NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
                compile.setToolChain(toolChain);
                if (binary instanceof SwiftExecutable) {
                    LinkExecutable link = (LinkExecutable)tasks.create(names.getTaskName("link"), LinkExecutable.class);
                    link.source((Object)compile.getObjectFileDir().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
                    link.lib((Object)binary.getLinkLibraries());
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    Provider exeLocation = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getModule().get());
                        }
                    }));
                    link.setOutputFile(exeLocation);
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                    link.setDebuggable(binary.isDebuggable());
                    InstallExecutable install = (InstallExecutable)tasks.create(names.getTaskName("install"), InstallExecutable.class);
                    install.setPlatform(link.getTargetPlatform());
                    install.setToolChain((ToolChain)link.getToolChain());
                    install.setDestinationDir(buildDirectory.dir("install/" + names.getDirName()));
                    install.setExecutable((Provider)link.getBinaryFile());
                    install.lib((Object)binary.getRuntimeLibraries());
                } else if (binary instanceof SwiftSharedLibrary) {
                    compile.getCompilerArgs().set(Arrays.asList("-parse-as-library"));
                    LinkSharedLibrary link = (LinkSharedLibrary)tasks.create(names.getTaskName("link"), LinkSharedLibrary.class);
                    link.source((Object)compile.getObjectFileDir().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
                    link.lib((Object)binary.getLinkLibraries());
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    Provider runtimeFile = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + (String)binary.getModule().get());
                        }
                    }));
                    link.setOutputFile(runtimeFile);
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                    link.setDebuggable(binary.isDebuggable());
                } else if (binary instanceof SwiftBundle) {
                    compile.getCompilerArgs().set(Arrays.asList("-parse-as-library"));
                    LinkMachOBundle link = (LinkMachOBundle)tasks.create(names.getTaskName("link"), LinkMachOBundle.class);
                    link.source((Object)compile.getObjectFileDir().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
                    link.lib((Object)binary.getLinkLibraries());
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    Provider exeLocation = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getModule().get());
                        }
                    }));
                    link.setOutputFile(exeLocation);
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                    link.setDebuggable(binary.isDebuggable());
                    final CreateSwiftBundle bundle = (CreateSwiftBundle)tasks.create(names.getTaskName("bundleSwift"), CreateSwiftBundle.class);
                    bundle.getExecutableFile().set((Provider)link.getBinaryFile());
                    bundle.getInformationFile().set(((SwiftBundle)binary).getInformationPropertyList());
                    Provider bundleLocation = buildDirectory.dir(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return "bundle/" + names.getDirName() + (String)binary.getModule().get() + ".xctest";
                        }
                    }));
                    bundle.getOutputDir().set(bundleLocation);
                    bundle.onlyIf((Spec)new Spec<Task>(){

                        public boolean isSatisfiedBy(Task element) {
                            return ((File)bundle.getExecutableFile().getAsFile().get()).exists();
                        }
                    });
                }
            }
        });
    }
}

