/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;

public class NativeVariant
implements SoftwareComponentInternal {
    private final String name;
    private final Usage linkUsage;
    private final Configuration linkElements;
    private final Usage runtimeUsage;
    private final Set<? extends PublishArtifact> runtimeArtifacts;
    private final Configuration runtimeElementsConfiguration;

    public NativeVariant(String name, Usage usage, Set<? extends PublishArtifact> artifacts, Configuration dependencies) {
        this.name = name;
        this.linkUsage = null;
        this.linkElements = null;
        this.runtimeUsage = usage;
        this.runtimeArtifacts = artifacts;
        this.runtimeElementsConfiguration = dependencies;
    }

    public NativeVariant(String name, Usage linkUsage, Configuration linkElements, Usage runtimeUsage, Configuration runtimeElements) {
        this.name = name;
        this.linkUsage = linkUsage;
        this.linkElements = linkElements;
        this.runtimeUsage = runtimeUsage;
        this.runtimeArtifacts = runtimeElements.getAllArtifacts();
        this.runtimeElementsConfiguration = runtimeElements;
    }

    public String getName() {
        return this.name;
    }

    public Set<? extends UsageContext> getUsages() {
        if (this.linkElements == null) {
            return ImmutableSet.of((Object)new SimpleUsage(this.runtimeUsage, this.runtimeArtifacts, this.runtimeElementsConfiguration));
        }
        return ImmutableSet.of((Object)new SimpleUsage(this.linkUsage, (Set<? extends PublishArtifact>)this.linkElements.getAllArtifacts(), this.linkElements), (Object)new SimpleUsage(this.runtimeUsage, this.runtimeArtifacts, this.runtimeElementsConfiguration));
    }

    private static class SimpleUsage
    implements UsageContext {
        private final Usage usage;
        private final Set<? extends PublishArtifact> artifacts;
        private final Set<ModuleDependency> dependencies;

        SimpleUsage(Usage usage, Set<? extends PublishArtifact> artifacts, Configuration configuration) {
            this.usage = usage;
            this.artifacts = artifacts;
            this.dependencies = configuration.getAllDependencies().withType(ModuleDependency.class);
        }

        public Usage getUsage() {
            return this.usage;
        }

        public Set<? extends PublishArtifact> getArtifacts() {
            return this.artifacts;
        }

        public Set<ModuleDependency> getDependencies() {
            return this.dependencies;
        }
    }
}

