/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.base.MoreObjects;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeBuilder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class PsiFileStubImpl<T extends PsiFile>
extends StubBase<T>
implements PsiFileStub<T> {
    public static final IStubFileElementType TYPE = new IStubFileElementType(Language.ANY);
    private volatile T myFile;
    private volatile String myInvalidationReason;
    private volatile PsiFileStub[] myStubRoots;

    public PsiFileStubImpl(T file) {
        super(null, null);
        this.myFile = file;
    }

    @Override
    public T getPsi() {
        return this.myFile;
    }

    @Override
    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl", "setPsi"));
        }
        this.myFile = psi;
    }

    public void clearPsi(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl", "clearPsi"));
        }
        this.myInvalidationReason = reason;
        this.myFile = null;
    }

    @Override
    @Nullable
    public String getInvalidationReason() {
        return this.myInvalidationReason;
    }

    @Override
    public IStubElementType getStubType() {
        return null;
    }

    @Override
    @NotNull
    public IStubFileElementType getType() {
        IStubFileElementType iStubFileElementType = TYPE;
        if (iStubFileElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl", "getType"));
        }
        return iStubFileElementType;
    }

    @Override
    @NotNull
    public PsiFileStub[] getStubRoots() {
        if (this.myStubRoots != null) {
            if (this.myStubRoots == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
            }
            return this.myStubRoots;
        }
        PsiElement psi = this.getPsi();
        if (psi == null) {
            PsiFileStub[] psiFileStubArray = new PsiFileStub[]{this};
            if (psiFileStubArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
            }
            return psiFileStubArray;
        }
        FileViewProvider viewProvider = psi.getViewProvider();
        PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        StubTree baseTree = PsiFileStubImpl.getOrCalcStubTree(stubBindingRoot);
        if (baseTree != null) {
            PsiFileStub[] rootsArray;
            SmartList<PsiFileStub> roots2 = new SmartList<PsiFileStub>(baseTree.getRoot());
            List<Pair<IStubFileElementType, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRoots(viewProvider);
            for (Pair<IStubFileElementType, PsiFile> stubbedRoot : stubbedRoots) {
                StubTree secondaryStubTree;
                if (stubbedRoot.second == stubBindingRoot || (secondaryStubTree = PsiFileStubImpl.getOrCalcStubTree((PsiFile)stubbedRoot.second)) == null) continue;
                PsiFileStub root2 = secondaryStubTree.getRoot();
                roots2.add(root2);
            }
            for (PsiFileStub root3 : rootsArray = roots2.toArray(new PsiFileStub[roots2.size()])) {
                if (!(root3 instanceof PsiFileStubImpl)) continue;
                ((PsiFileStubImpl)root3).setStubRoots(rootsArray);
            }
            this.myStubRoots = rootsArray;
            if (rootsArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
            }
            return rootsArray;
        }
        if (PsiFileStub.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
        }
        return PsiFileStub.EMPTY_ARRAY;
    }

    private static StubTree getOrCalcStubTree(PsiFile stubBindingRoot) {
        StubTree result2 = null;
        if (stubBindingRoot instanceof PsiFileWithStubSupport && (result2 = ((PsiFileWithStubSupport)stubBindingRoot).getStubTree()) == null && stubBindingRoot instanceof PsiFileImpl) {
            result2 = ((PsiFileImpl)stubBindingRoot).calcStubTree();
        }
        return result2;
    }

    public void setStubRoots(@NotNull PsiFileStub[] roots2) {
        if (roots2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl", "setStubRoots"));
        }
        if (roots2.length == 0) {
            Logger.getInstance(this.getClass()).error("Incorrect psi file stub roots count" + this + "," + this.getStubType());
        }
        this.myStubRoots = roots2;
    }

    public boolean rootsAreSet() {
        return this.myStubRoots != null;
    }

    public String getDiagnostics() {
        ObjectStubTree stubTree = ObjectStubTree.getStubTree(this);
        T file = this.myFile;
        return this.toString() + MoreObjects.toStringHelper("").add("myFile", file).add("myInvalidationReason", this.myInvalidationReason).add("myStubRoots", Arrays.toString(this.myStubRoots)).add("stubTree", stubTree).toString();
    }
}

