/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.RangeMarkerEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.IntervalTreeImpl;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.RangeMarkerTree;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.StripedIDGenerator;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UnfairTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.RangeMarkerImpl");
    private final DocumentEx myDocument;
    RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    private final long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    protected boolean unregisterInTree() {
        if (!this.isValid()) {
            return false;
        }
        IntervalTreeImpl tree = this.myNode.getTree();
        tree.checkMax(true);
        boolean b = this.myDocument.removeRangeMarker(this);
        tree.checkMax(true);
        return b;
    }

    public long getId() {
        return this.myId;
    }

    @Override
    public void dispose() {
        this.unregisterInTree();
    }

    @Override
    public int getStartOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? -1 : node.intervalStart() + node.computeDeltaUpToRoot();
    }

    @Override
    public int getEndOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? -1 : node.intervalEnd() + node.computeDeltaUpToRoot();
    }

    void invalidate(@NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl", "invalidate"));
        }
        this.setValid(false);
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node != null) {
            node.processAliveKeys(markerEx -> {
                if (reason == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl", "lambda$invalidate$0"));
                }
                this.myNode.getTree().beforeRemove(markerEx, reason);
                return true;
            });
        }
    }

    @Override
    @NotNull
    public DocumentEx getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl", "getDocument"));
        }
        return documentEx;
    }

    @Override
    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToLeft();
    }

    @Override
    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToRight();
    }

    public final void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl", "documentChanged"));
        }
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = this.myDocument.getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (this.intervalStart() > this.intervalEnd() || this.intervalStart() < 0 || this.intervalEnd() > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate(e);
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid() && (this.intervalStart() > this.intervalEnd() || this.intervalStart() < 0 || this.intervalEnd() > docLength)) {
            LOG.error("Update failed. Event = " + e + ". old doc length=" + docLength + "; real doc length = " + this.myDocument.getTextLength() + "; " + this.getClass() + ". After update: '" + this + "'");
            this.invalidate(e);
        }
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl", "changedUpdateImpl"));
        }
        if (!this.isValid()) {
            return;
        }
        TextRange newRange = RangeMarkerImpl.applyChange(e, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight());
        if (newRange == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(newRange.getStartOffset());
        this.setIntervalEnd(newRange.getEndOffset());
    }

    @Nullable
    static TextRange applyChange(@NotNull DocumentEvent e, int intervalStart, int intervalEnd, boolean isGreedyToLeft, boolean isGreedyToRight) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl", "applyChange"));
        }
        if (intervalStart == intervalEnd) {
            return RangeMarkerImpl.processIfOnePoint(e, intervalStart, isGreedyToRight);
        }
        int offset2 = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (intervalEnd < offset2) {
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (!isGreedyToRight && intervalEnd == offset2) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() < offset2) {
                return new UnfairTextRange(intervalStart, intervalEnd + newLength);
            }
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (intervalStart > offset2 + oldLength) {
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (!isGreedyToLeft && intervalStart == offset2 + oldLength) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() + ((DocumentEventImpl)e).getInitialOldLength() > offset2) {
                return new UnfairTextRange(intervalStart - oldLength, intervalEnd + newLength - oldLength);
            }
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (intervalStart <= offset2 && intervalEnd >= offset2 + oldLength) {
            return new ProperTextRange(intervalStart, intervalEnd + newLength - oldLength);
        }
        if (intervalStart >= offset2 && intervalStart <= offset2 + oldLength && intervalEnd > offset2 + oldLength) {
            return new ProperTextRange(offset2 + newLength, intervalEnd + newLength - oldLength);
        }
        if (intervalEnd >= offset2 && intervalEnd <= offset2 + oldLength && intervalStart < offset2) {
            return new UnfairTextRange(intervalStart, offset2);
        }
        return null;
    }

    @Nullable
    private static TextRange processIfOnePoint(@NotNull DocumentEvent e, int intervalStart, boolean greedyRight) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl", "processIfOnePoint"));
        }
        int offset2 = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset2 + oldLength;
        if (offset2 < intervalStart && intervalStart < oldEnd) {
            return null;
        }
        if (offset2 == intervalStart && oldLength == 0 && greedyRight) {
            return new UnfairTextRange(intervalStart, intervalStart + e.getNewLength());
        }
        if (intervalStart > oldEnd || intervalStart == oldEnd && oldLength > 0) {
            return new UnfairTextRange(intervalStart + e.getNewLength() - oldLength, intervalStart + e.getNewLength() - oldLength);
        }
        return new UnfairTextRange(intervalStart, intervalStart);
    }

    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "" : "invalid:") + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }

    public int setIntervalStart(int start) {
        if (start < 0) {
            LOG.error("Negative start: " + start);
        }
        return this.myNode.setIntervalStart(start);
    }

    public int setIntervalEnd(int end) {
        if (end < 0) {
            LOG.error("Negative end: " + end);
        }
        return this.myNode.setIntervalEnd(end);
    }

    @Override
    public boolean isValid() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isValid();
    }

    public boolean setValid(boolean value) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null || node.setValid(value);
    }

    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalStart();
    }

    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalEnd();
    }
}

