/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;

public class DependencyMapNotationConverter<T extends ExternalDependency>
extends MapNotationConverter<T> {
    private final Instantiator instantiator;
    private final Class<T> resultingType;

    public DependencyMapNotationConverter(Instantiator instantiator, Class<T> resultingType) {
        this.instantiator = instantiator;
        this.resultingType = resultingType;
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("Maps").example("[group: 'org.gradle', name: 'gradle-core', version: '1.0']");
    }

    protected T parseMap(@MapKey(value="group") @Optional String group, @MapKey(value="name") @Optional String name, @MapKey(value="version") @Optional String version, @MapKey(value="configuration") @Optional String configuration, @MapKey(value="ext") @Optional String ext, @MapKey(value="classifier") @Optional String classifier) {
        ExternalDependency dependency = (ExternalDependency)this.instantiator.newInstance(this.resultingType, new Object[]{group, name, version, configuration});
        ModuleFactoryHelper.addExplicitArtifactsIfDefined(dependency, ext, classifier);
        return (T)dependency;
    }
}

