/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;

public class ModuleForcingResolveRule
implements Action<DependencySubstitutionInternal> {
    private final Map<ModuleIdentifier, String> forcedModules;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public ModuleForcingResolveRule(Collection<? extends ModuleVersionSelector> forcedModules, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        if (!forcedModules.isEmpty()) {
            this.forcedModules = new HashMap<ModuleIdentifier, String>();
            for (ModuleVersionSelector moduleVersionSelector : forcedModules) {
                this.forcedModules.put(moduleIdentifierFactory.module(moduleVersionSelector.getGroup(), moduleVersionSelector.getName()), moduleVersionSelector.getVersion());
            }
        } else {
            this.forcedModules = null;
        }
    }

    public void execute(DependencySubstitutionInternal details) {
        if (this.forcedModules == null) {
            return;
        }
        ModuleIdentifier key = this.moduleIdentifierFactory.module(details.getOldRequested().getGroup(), details.getOldRequested().getName());
        if (this.forcedModules.containsKey(key) && details.getRequested() instanceof ModuleComponentSelector) {
            details.useTarget(DefaultModuleComponentSelector.newSelector(key.getGroup(), key.getName(), this.forcedModules.get(key)), VersionSelectionReasons.FORCED);
        }
    }
}

