/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListBuildOption<T>
extends AbstractBuildOption<T> {
    public ListBuildOption(String gradleProperty) {
        super(gradleProperty);
    }

    public ListBuildOption(String gradleProperty, CommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        super(gradleProperty, commandLineOptionConfigurations);
    }

    @Override
    public void applyFromProperty(Map<String, String> properties, T settings) {
        String value = properties.get(this.gradleProperty);
        if (value != null) {
            String[] splitValues = value.split("\\s*,\\s*");
            this.applyTo(Arrays.asList(splitValues), settings, Origin.forGradleProperty(this.gradleProperty));
        }
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            this.configureCommandLineOption(parser, config.getAllOptions(), config.getDescription(), config.getDeprecationWarning(), config.isIncubating()).hasArguments();
        }
    }

    @Override
    public void applyFromCommandLine(ParsedCommandLine options, T settings) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            if (!options.hasOption(config.getLongOption())) continue;
            List value = options.option(config.getLongOption()).getValues();
            this.applyTo(value, settings, Origin.forCommandLine(config.getLongOption()));
        }
    }

    public abstract void applyTo(List<String> var1, T var2, Origin var3);
}

