/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.experimental;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.CancellableContinuation;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.CoroutineDispatcher;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.Delay;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.DisposableFutureHandle;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.DisposableHandle;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.Job;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.JobKt;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.ResumeRunnable;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.ResumeUndispatchedRunnable;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.ScheduledKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/ExecutorCoroutineDispatcher;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/CoroutineDispatcher;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/Delay;", "executor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "dispatch", "", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "block", "Ljava/lang/Runnable;", "invokeOnTimeout", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/DisposableHandle;", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "scheduleResumeAfterDelay", "continuation", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/CancellableContinuation;", "kotlinx-coroutines-core"})
public class ExecutorCoroutineDispatcher
extends CoroutineDispatcher
implements Delay {
    private final Executor executor;

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        this.executor.execute(block);
    }

    @Override
    public void scheduleResumeAfterDelay(long time, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation2) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
        ScheduledFuture<?> timeout = this.executor instanceof ScheduledExecutorService ? ((ScheduledExecutorService)this.executor).schedule(new ResumeUndispatchedRunnable(this, continuation2), time, unit) : ScheduledKt.getScheduledExecutor().schedule(new ResumeRunnable((Continuation<? super Unit>)continuation2), time, unit);
        Job job = continuation2;
        ScheduledFuture<?> scheduledFuture = timeout;
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, "timeout");
        JobKt.cancelFutureOnCompletion(job, (Future)scheduledFuture);
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long time, @NotNull TimeUnit unit, @NotNull Runnable block) {
        ScheduledFuture<?> timeout;
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(block, "block");
        ScheduledFuture<?> scheduledFuture = timeout = this.executor instanceof ScheduledExecutorService ? ((ScheduledExecutorService)this.executor).schedule(block, time, unit) : ScheduledKt.getScheduledExecutor().schedule(block, time, unit);
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, "timeout");
        return new DisposableFutureHandle((Future)scheduledFuture);
    }

    public ExecutorCoroutineDispatcher(@NotNull Executor executor2) {
        Intrinsics.checkParameterIsNotNull(executor2, "executor");
        this.executor = executor2;
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> $continuation) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull($continuation, "$continuation");
        return Delay.DefaultImpls.delay(this, time, unit, $continuation);
    }
}

