/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.common.modules.ModuleXmlParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;

public class CompileEnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(CompileEnvironmentUtil.class);

    @NotNull
    public static ModuleScriptData loadModuleDescriptions(String moduleDefinitionFile, MessageCollector messageCollector2) {
        File file = new File(moduleDefinitionFile);
        if (!file.exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Module definition file does not exist: " + moduleDefinitionFile, null);
            ModuleScriptData moduleScriptData = ModuleScriptData.EMPTY;
            if (moduleScriptData == null) {
                CompileEnvironmentUtil.$$$reportNull$$$0(0);
            }
            return moduleScriptData;
        }
        String extension = FileUtilRt.getExtension(moduleDefinitionFile);
        if ("xml".equalsIgnoreCase(extension)) {
            ModuleScriptData moduleScriptData = ModuleXmlParser.parseModuleScript(moduleDefinitionFile, messageCollector2);
            if (moduleScriptData == null) {
                CompileEnvironmentUtil.$$$reportNull$$$0(1);
            }
            return moduleScriptData;
        }
        messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module definition type: " + moduleDefinitionFile, null);
        ModuleScriptData moduleScriptData = ModuleScriptData.EMPTY;
        if (moduleScriptData == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(2);
        }
        return moduleScriptData;
    }

    private static void doWriteToJar(OutputFileCollection outputFiles, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime) {
        try {
            Manifest manifest2 = new Manifest();
            Attributes mainAttributes = manifest2.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.asString());
            }
            JarOutputStream stream2 = new JarOutputStream(fos, manifest2);
            for (OutputFile outputFile : outputFiles.asList()) {
                stream2.putNextEntry(new JarEntry(outputFile.getRelativePath()));
                stream2.write(outputFile.asByteArray());
            }
            if (includeRuntime) {
                CompileEnvironmentUtil.writeRuntimeToJar(stream2);
            }
            stream2.finish();
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToJar(File jarPath, boolean jarRuntime, FqName mainClass, OutputFileCollection outputFiles) {
        FileOutputStream outputStream2 = null;
        try {
            outputStream2 = new FileOutputStream(jarPath);
            CompileEnvironmentUtil.doWriteToJar(outputFiles, outputStream2, mainClass, jarRuntime);
            outputStream2.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompileEnvironmentException("Invalid jar path " + jarPath, e);
                catch (IOException e2) {
                    throw ExceptionUtilsKt.rethrow(e2);
                }
            }
            catch (Throwable throwable) {
                ExceptionUtilsKt.closeQuietly(outputStream2);
                throw throwable;
            }
        }
        ExceptionUtilsKt.closeQuietly(outputStream2);
    }

    private static void writeRuntimeToJar(JarOutputStream stream2) throws IOException {
        File runtimePath = PathUtil.getKotlinPathsForCompiler().getRuntimePath();
        if (!runtimePath.exists()) {
            throw new CompileEnvironmentException("Couldn't find runtime library");
        }
        File scriptRuntimePath = PathUtil.getKotlinPathsForCompiler().getScriptRuntimePath();
        if (!scriptRuntimePath.exists()) {
            throw new CompileEnvironmentException("Couldn't find script runtime library");
        }
        CompileEnvironmentUtil.copyJarImpl(stream2, runtimePath);
    }

    private static void copyJarImpl(JarOutputStream stream2, File jarPath) throws IOException {
        try (JarInputStream jis = new JarInputStream(new FileInputStream(jarPath));){
            JarEntry e;
            while ((e = jis.getNextJarEntry()) != null) {
                if (!FileUtilRt.extensionEquals(e.getName(), "class")) continue;
                stream2.putNextEntry(e);
                FileUtil.copy(jis, stream2);
            }
        }
    }

    @NotNull
    public static List<KtFile> getKtFiles(@NotNull Project project, @NotNull Collection<String> sourceRoots, @NotNull CompilerConfiguration configuration, @NotNull Function1<String, Unit> reportError2) throws IOException {
        if (project == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(3);
        }
        if (sourceRoots == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(5);
        }
        if (reportError2 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(6);
        }
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet processedFiles = Sets.newHashSet();
        ArrayList<KtFile> result2 = Lists.newArrayList();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        for (String sourceRootPath : sourceRoots) {
            if (sourceRootPath == null) continue;
            VirtualFile vFile = localFileSystem.findFileByPath(sourceRootPath);
            if (vFile == null) {
                String message = "Source file or directory not found: " + sourceRootPath;
                File buildFilePath = configuration.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    LOG.warn(message + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FileUtil.loadFile(buildFilePath));
                }
                reportError2.invoke(message);
                continue;
            }
            if (!vFile.isDirectory() && vFile.getFileType() != KotlinFileType.INSTANCE) {
                reportError2.invoke("Source entry is not a Kotlin file: " + sourceRootPath);
                continue;
            }
            SequencesKt.forEach(FilesKt.walkTopDown(new File(sourceRootPath)), file -> {
                if (project == null) {
                    CompileEnvironmentUtil.$$$reportNull$$$0(8);
                }
                if (file.isFile()) {
                    VirtualFile virtualFile2;
                    VirtualFile originalVirtualFile = localFileSystem.findFileByPath(file.getAbsolutePath());
                    VirtualFile virtualFile3 = virtualFile2 = originalVirtualFile != null ? virtualFileCreator.create(originalVirtualFile) : null;
                    if (virtualFile2 != null && !processedFiles.contains(virtualFile2)) {
                        processedFiles.add(virtualFile2);
                        PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile2);
                        if (psiFile instanceof KtFile) {
                            result2.add((KtFile)psiFile);
                        }
                    }
                }
                return Unit.INSTANCE;
            });
        }
        ArrayList<KtFile> arrayList = result2;
        if (arrayList == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModuleDescriptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKtFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getKtFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getKtFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

