/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.groovy.builder.factory;

import groovy.lang.Closure;
import groovy.util.FactoryBuilderSupport;
import groovy.util.Node;
import groovy.util.NodeBuilder;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.sonatype.maven.polyglot.groovy.builder.factory.NamedFactory;

public class PropertiesFactory
extends NamedFactory {
    public PropertiesFactory(String name) {
        super(name);
    }

    public boolean isHandlesNodeChildren() {
        return true;
    }

    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attrs) throws InstantiationException, IllegalAccessException {
        return new Properties();
    }

    public boolean onNodeChildren(FactoryBuilderSupport builder, Object node, Closure content) {
        Properties props = (Properties)node;
        NodeBuilder nodes = new NodeBuilder(){

            protected void setClosureDelegate(Closure c, Object o) {
                c.setDelegate((Object)this);
                c.setResolveStrategy(1);
            }

            public void setProperty(String name, Object value) {
                this.invokeMethod(name, value);
            }
        };
        content.setDelegate((Object)nodes);
        content.setResolveStrategy(1);
        Node root = (Node)nodes.invokeMethod(this.getName(), (Object)content);
        for (Node child : (List)root.value()) {
            this.merge(props, child, "");
        }
        return false;
    }

    private void merge(Properties props, Node node, String prefix) {
        assert (props != null);
        assert (node != null);
        assert (prefix != null);
        String name = prefix + node.name();
        Object value = node.value();
        if (value instanceof String) {
            props.setProperty(name, String.valueOf(value));
        }
        Map attrs = node.attributes();
        for (Object key : attrs.keySet()) {
            props.setProperty(name + "." + key, String.valueOf(attrs.get(key)));
        }
        for (Object child : node.children()) {
            if (!(child instanceof Node)) continue;
            this.merge(props, (Node)child, name + ".");
        }
    }
}

