/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.tasks.diagnostics.internal.graph.LegendRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvableConfigurationResult;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class DependencyGraphRenderer {
    private final GraphRenderer renderer;
    private final NodeRenderer nodeRenderer;
    private final LegendRenderer legendRenderer;

    public DependencyGraphRenderer(GraphRenderer renderer, NodeRenderer nodeRenderer, LegendRenderer legendRenderer) {
        this.renderer = renderer;
        this.nodeRenderer = nodeRenderer;
        this.legendRenderer = legendRenderer;
    }

    public void render(RenderableDependency root) {
        if (root instanceof UnresolvableConfigurationResult) {
            this.legendRenderer.setHasUnresolvableConfigurations(true);
        }
        HashSet visited = Sets.newHashSet();
        visited.add(root.getId());
        this.renderChildren(root.getChildren(), visited);
    }

    private void renderChildren(Set<? extends RenderableDependency> children, Set<Object> visited) {
        this.renderer.startChildren();
        Integer i = 0;
        for (RenderableDependency renderableDependency : children) {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            boolean last = n == children.size() - 1;
            this.doRender(renderableDependency, last, visited);
        }
        this.renderer.completeChildren();
    }

    private void doRender(final RenderableDependency node, boolean last, Set<Object> visited) {
        boolean alreadyRendered;
        Set<? extends RenderableDependency> children = node.getChildren();
        boolean bl = alreadyRendered = !visited.add(node.getId());
        if (alreadyRendered) {
            this.legendRenderer.setHasCyclicDependencies(true);
        }
        this.renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput output) {
                DependencyGraphRenderer.this.nodeRenderer.renderNode(output, node, alreadyRendered);
            }
        }, last);
        if (!alreadyRendered) {
            this.renderChildren(children, visited);
        }
    }
}

