/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Style {
    public static final Style NORMAL = Style.of(Color.DEFAULT);
    public final Set<Emphasis> emphasises;
    public final Color color;

    public Style(Set<Emphasis> emphasises, Color color) {
        this.emphasises = emphasises;
        this.color = color;
    }

    public Set<Emphasis> getEmphasises() {
        return this.emphasises;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Style rhs = (Style)obj;
        return Objects.equal(this.getEmphasises(), rhs.getEmphasises()) && Objects.equal((Object)((Object)this.getColor()), (Object)((Object)rhs.getColor()));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getEmphasises(), this.getColor()});
    }

    public static Style of(Emphasis emphasis) {
        return Style.of(emphasis, Color.DEFAULT);
    }

    public static Style of(Emphasis emphasis, Color color) {
        return new Style(EnumSet.of(emphasis), color);
    }

    public static Style of(Color color) {
        return new Style(Collections.EMPTY_SET, color);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Color {
        DEFAULT,
        YELLOW,
        RED,
        GREY,
        GREEN,
        BLACK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Emphasis {
        BOLD,
        REVERSE,
        ITALIC;

    }
}

