/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.DefaultCandidateResult;
import org.gradle.internal.component.model.DefaultCompatibilityCheckResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentAttributeMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAttributeMatcher.class);

    public boolean isMatching(AttributeSelectionSchema schema, AttributeContainer candidate, AttributeContainer requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return true;
        }
        MatchDetails<AttributeContainer> details = new MatchDetails<AttributeContainer>(candidate);
        this.doMatchCandidate(schema, (HasAttributes)candidate, requested, details);
        return ((MatchDetails)details).compatible;
    }

    public <T extends HasAttributes> List<T> match(AttributeSelectionSchema schema, Collection<? extends T> candidates, AttributeContainer requested, @Nullable T fallback) {
        if (candidates.size() == 0) {
            if (fallback != null && this.isMatching(schema, fallback.getAttributes(), requested)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No candidates for {}, selected matching fallback {}", (Object)requested, fallback);
                }
                return ImmutableList.of(fallback);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No candidates for {} and fallback {} does not match. Select nothing.", (Object)requested, fallback);
            }
            return ImmutableList.of();
        }
        if (candidates.size() == 1) {
            HasAttributes candidate = (HasAttributes)candidates.iterator().next();
            if (this.isMatching(schema, candidate.getAttributes(), requested)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Selected match {} from candidates {} for {}", new Object[]{candidate, candidates, requested});
                }
                return Collections.singletonList(candidate);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Selected match [] from candidates {} for {}", candidates, (Object)requested);
            }
            return ImmutableList.of();
        }
        List<? extends T> matches = new Matcher<T>(schema, candidates, requested).getMatches();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Selected matches {} from candidates {} for {}", new Object[]{matches, candidates, requested});
        }
        return matches;
    }

    private void doMatchCandidate(AttributeSelectionSchema schema, HasAttributes candidate, AttributeContainer requested, MatchDetails details) {
        Attribute attribute;
        Set requestedAttributes = (Set)Cast.uncheckedCast((Object)requested.keySet());
        AttributeContainer candidateAttributesContainer = candidate.getAttributes();
        Set candidateAttributes = (Set)Cast.uncheckedCast((Object)candidateAttributesContainer.keySet());
        Iterator requestedIterator = requestedAttributes.iterator();
        while (details.compatible && requestedIterator.hasNext()) {
            attribute = (Attribute)requestedIterator.next();
            AttributeValue<Object> requestedValue = this.attributeValue((Attribute<Object>)attribute, schema, requested);
            AttributeValue<Object> actualValue = this.attributeValue((Attribute<Object>)attribute, schema, candidateAttributesContainer);
            if (!actualValue.isPresent()) continue;
            details.update((Attribute<Object>)attribute, schema, requestedValue, actualValue);
        }
        if (!details.compatible) {
            return;
        }
        Iterator candidateIterator = candidateAttributes.iterator();
        while (details.compatible && candidateIterator.hasNext()) {
            attribute = (Attribute)candidateIterator.next();
            if (requestedAttributes.contains(attribute)) continue;
            AttributeValue<Object> actualValue = this.attributeValue((Attribute<Object>)attribute, schema, candidateAttributesContainer);
            details.updateForMissingConsumerValue((Attribute<Object>)attribute, actualValue);
        }
    }

    private AttributeValue<Object> attributeValue(Attribute<Object> attribute, AttributeSelectionSchema schema, AttributeContainer container) {
        if (container.contains(attribute)) {
            return AttributeValue.of(container.getAttribute(attribute));
        }
        if (schema.hasAttribute(attribute)) {
            return AttributeValue.missing();
        }
        return AttributeValue.unknown();
    }

    private static class MatchDetails<T extends HasAttributes> {
        private final Set<Attribute<Object>> matched = Sets.newHashSet();
        private final Map<Attribute<Object>, Object> matchesByAttribute = Maps.newHashMap();
        private final T candidate;
        private boolean compatible = true;

        MatchDetails(T candidate) {
            this.candidate = candidate;
        }

        void update(Attribute<Object> attribute, AttributeSelectionSchema schema, AttributeValue<Object> consumerValue, AttributeValue<Object> producerValue) {
            DefaultCompatibilityCheckResult<Object> details = new DefaultCompatibilityCheckResult<Object>(consumerValue.get(), producerValue.get());
            schema.matchValue(attribute, details);
            if (details.isCompatible()) {
                this.matched.add(attribute);
                this.matchesByAttribute.put(attribute, producerValue.get());
            } else {
                this.compatible = false;
            }
        }

        void updateForMissingConsumerValue(Attribute<Object> attribute, AttributeValue<Object> producerValue) {
            this.matchesByAttribute.put(attribute, producerValue.get());
        }
    }

    private class Matcher<T extends HasAttributes> {
        private final AttributeSelectionSchema schema;
        private final List<MatchDetails<T>> matchDetails;
        private final AttributeContainer requested;

        public Matcher(AttributeSelectionSchema schema, Collection<? extends T> candidates, AttributeContainer requested) {
            this.schema = schema;
            this.matchDetails = Lists.newArrayListWithCapacity((int)candidates.size());
            for (HasAttributes cand : candidates) {
                this.matchDetails.add(new MatchDetails<HasAttributes>(cand));
            }
            this.requested = requested;
            this.doMatch();
        }

        private void doMatch() {
            for (MatchDetails<T> matchDetail : this.matchDetails) {
                ComponentAttributeMatcher.this.doMatchCandidate(this.schema, ((MatchDetails)matchDetail).candidate, this.requested, matchDetail);
            }
        }

        public List<T> getMatches() {
            List<MatchDetails<T>> compatible = new ArrayList<MatchDetails<T>>(1);
            for (MatchDetails<T> details : this.matchDetails) {
                if (!((MatchDetails)details).compatible) continue;
                compatible.add(details);
            }
            if (compatible.size() > 1) {
                compatible = this.selectClosestMatches(compatible);
            }
            if (compatible.isEmpty()) {
                return Collections.emptyList();
            }
            if (compatible.size() == 1) {
                return Collections.singletonList(((MatchDetails)compatible.get(0)).candidate);
            }
            ArrayList<HasAttributes> selected = new ArrayList<HasAttributes>(compatible.size());
            for (MatchDetails<T> details : compatible) {
                selected.add(((MatchDetails)details).candidate);
            }
            return selected;
        }

        private List<MatchDetails<T>> selectClosestMatches(List<MatchDetails<T>> compatible) {
            for (MatchDetails<T> details : compatible) {
                boolean superSetToAll = true;
                for (MatchDetails<T> candidate : compatible) {
                    if (details == candidate || ((MatchDetails)details).matched.containsAll(((MatchDetails)candidate).matched) && !((MatchDetails)details).matched.equals(((MatchDetails)candidate).matched)) continue;
                    superSetToAll = false;
                    break;
                }
                if (!superSetToAll) continue;
                return Collections.singletonList(details);
            }
            ArrayList remainingMatches = Lists.newArrayList(compatible);
            ArrayList best = Lists.newArrayListWithCapacity((int)compatible.size());
            LinkedHashMultimap candidatesByValue = LinkedHashMultimap.create();
            HashSet allAttributes = Sets.newHashSet();
            for (MatchDetails<T> details : compatible) {
                allAttributes.addAll(((MatchDetails)details).matchesByAttribute.keySet());
            }
            for (Attribute attribute : allAttributes) {
                for (MatchDetails<T> details : compatible) {
                    Map matchedAttributes = ((MatchDetails)details).matchesByAttribute;
                    Object val = matchedAttributes.get(attribute);
                    candidatesByValue.put(val, details);
                }
                this.disambiguate((Attribute<?>)attribute, this.requested.getAttribute(attribute), remainingMatches, (Multimap<Object, MatchDetails<T>>)candidatesByValue, this.schema, best);
                if (remainingMatches.isEmpty()) {
                    return compatible;
                }
                candidatesByValue.clear();
                best.clear();
            }
            return remainingMatches;
        }

        private void disambiguate(Attribute<?> attribute, Object requested, List<MatchDetails<T>> remainingMatches, Multimap<Object, MatchDetails<T>> candidatesByValue, AttributeSelectionSchema schema, List<MatchDetails<T>> best) {
            if (candidatesByValue.isEmpty()) {
                return;
            }
            DefaultCandidateResult<MatchDetails<T>> details = new DefaultCandidateResult<MatchDetails<T>>(candidatesByValue, requested, best);
            schema.disambiguate(attribute, details);
            remainingMatches.retainAll(best);
        }
    }
}

